% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-constructors.R
\name{mod_pois}
\alias{mod_pois}
\title{Specify a Poisson Model}
\usage{
mod_pois(formula, data, exposure)
}
\arguments{
\item{formula}{An R \link[stats:formula]{formula},
specifying the outcome and predictors.}

\item{data}{A data frame containing outcome,
predictor, and, optionally, exposure variables.}

\item{exposure}{Name of the exposure variable,
or a \code{1}, or a formula. See below for details.}
}
\value{
An object of class \code{bage_mod_pois}.
}
\description{
Specify a model where the outcome is drawn from a Poisson distribution.
}
\details{
The model is hierarchical. The rates in the Poisson distribution
are described by a prior model formed from dimensions such
as age, sex, and time. The terms for these dimension themselves
have models, as described in \link{priors}. These priors all have defaults,
which depend on the type of term (eg an intercept, an age main effect,
or an age-time interaction.)
}
\section{Mathematical details}{


The likelihood is

\deqn{y_i \sim \text{Poisson}(\gamma_i w_i)}

where
\itemize{
\item subscript \eqn{i} identifies some combination of
classifying variables, such as age, sex, and time;
\item \eqn{y_i} is an outcome, such as deaths;
\item \eqn{\gamma_i} is rates; and
\item \eqn{w_i} is exposure.
}

In some applications, there is no obvious population at risk.
In these cases, exposure \eqn{w_i} can be set to 1
for all \eqn{i}.

The rates \eqn{\gamma_i} are assumed to be drawn
a gamma distribution

\deqn{y_i \sim \text{Gamma}(\xi^{-1}, (\xi \mu_i)^{-1})}

where
\itemize{
\item \eqn{\mu_i} is the expected value for \eqn{\gamma_i}; and
\item \eqn{\xi} governs dispersion (ie variance.)
}

Expected value \eqn{\mu_i} equals, on the log scale,
the sum of terms formed from classifying variables,

\deqn{\log \mu_i = \sum_{m=0}^{M} \beta_{j_i^m}^{(m)}}

where
\itemize{
\item \eqn{\beta^{0}} is an intercept;
\item \eqn{\beta^{(m)}}, \eqn{m = 1, \dots, M}, is a main effect
or interaction; and
\item \eqn{j_i^m} is the element of \eqn{\beta^{(m)}} associated with
cell \eqn{i}.
}

The \eqn{\beta^{(m)}} are given priors, as described in \link{priors}.

The prior for \eqn{\xi} is described in \code{\link[=set_disp]{set_disp()}}.
}

\section{Specifying exposure}{


The \code{exposure} argument can take three forms:
\itemize{
\item the name of a variable in \code{data}, with or without
quote marks, eg \code{"population"} or \code{population};
\item the number \code{1}, in which case a pure "counts" model
with no exposure, is produced; or
\item a formula, which is evaluated with \code{data} as its
environment (see below for example).
}
}

\examples{
## specify a model with exposure
mod <- mod_pois(injuries ~ age:sex + ethnicity + year,
                data = injuries,
                exposure = popn)

## specify a model without exposure
mod <- mod_pois(injuries ~ age:sex + ethnicity + year,
                data = injuries,
                exposure = 1)

## use a formula to specify exposure
mod <- mod_pois(injuries ~ age:sex + ethnicity + year,
                data = injuries,
                exposure = ~ pmax(popn, 1))
}
\seealso{
\itemize{
\item \code{\link[=mod_binom]{mod_binom()}} Specify binomial model
\item \code{\link[=mod_norm]{mod_norm()}} Specify normal model
\item \code{\link[=set_prior]{set_prior()}} Specify non-default prior for term
\item \code{\link[=set_disp]{set_disp()}} Specify non-default prior for dispersion
\item \code{\link[=fit]{fit()}} Fit a model
\item \code{\link[=forecast]{forecast()}} Forecast a model
\item \code{\link[=report_sim]{report_sim()}} Do a simulation study on a model
}
}
