% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_ssvd-methods.R
\name{components.bage_ssvd}
\alias{components.bage_ssvd}
\title{Extract Components used by SVD Summary}
\usage{
\method{components}{bage_ssvd}(object, n_comp = NULL, indep = NULL, age_labels = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{"bage_ssvd"}.}

\item{n_comp}{The number of components.
The default is half the total number of
components of \code{object}.}

\item{indep}{Whether to use independent or
joint SVDs for each sex/gender. If
no value is supplied, an SVD with no
sex/gender dimension is used. Note that the
default is different from \code{\link[=SVD]{SVD()}}.}

\item{age_labels}{Age labels for the
desired age or age-sex profile.
If no labels are supplied, the
most detailed profile available is used.}

\item{...}{Not currently used.}
}
\value{
A tibble with the offset and components.
}
\description{
Extract the matrix and offset used by a scaled SVD
summary of a demographic database.
}
\section{Scaled SVDs of demographic databases in bage}{

\itemize{
\item \code{\link{HMD}} Mortality rates from the
\href{https://www.mortality.org}{Human Mortality Database}.
\item \code{\link{LFP}} Labor forcce participation
rates from the \href{https://data-explorer.oecd.org}{OECD}.
}
}

\examples{
## females and males combined
components(LFP, n_comp = 3)

## females and males modelled independently
components(LFP, indep = TRUE, n_comp = 3)

## joint model for females and males
components(LFP, indep = FALSE, n_comp = 3)

## specify age groups
labels <- poputils::age_labels(type = "five", min = 15, max = 60)
components(LFP, age_labels = labels)
}
\seealso{
\itemize{
\item \link[=generate]{generate()} Randomly generate
age-profiles, or age-sex profiles, based on a
scaled SVD summary.
\item \code{\link[=SVD]{SVD()}} SVD prior for terms involving age.
\item \code{\link[=SVD_AR1]{SVD_AR1()}}, \code{\link[=SVD_AR]{SVD_AR()}}, \code{\link[=SVD_RW]{SVD_RW()}}, \code{\link[=SVD_RW2]{SVD_RW2()}}
Dynamic SVD priors for terms involving age and time.
\item \code{\link[poputils:age_labels]{poputils::age_labels()}} Generate age labels.
}
}
