% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_prior-constructors.R
\name{Sp}
\alias{Sp}
\title{P-Spline Prior}
\usage{
Sp(n_comp = NULL, s = 1, along = NULL)
}
\arguments{
\item{n_comp}{Number of spline basis functions (components)
to use.}

\item{s}{Scale for the prior for the innovations.
Default is \code{1}.}

\item{along}{Name of the variable to be used
as the "along" variable. Only used with
interactions.}
}
\value{
An object of class \code{"bage_prior_spline"}.
}
\description{
Use a p-spline (penalised spine) to model main
effects or interactions. Typically used with age,
but can be used with any variable where outcomes are
expected to vary smoothly from one element to the next.
}
\details{
If \code{Sp()} is used with an interaction,
separate splines are used for the "along" variable within
each combination of the
"by" variables.
}
\section{Mathematical details}{


When \code{Sp()} is used with a main effect,

\deqn{\pmb{\beta} = \pmb{X} \pmb{\alpha}}

and when it is used with an interaction,

\deqn{\pmb{\beta}_u = \pmb{X} \pmb{\alpha}_u}

where
\itemize{
\item \eqn{\pmb{\beta}} is the main effect or interaction, with \eqn{J} elements;
\item \eqn{\pmb{beta}_u} is a subvector of \eqn{\pmb{\beta}} holding
values for the  \eqn{u}th combination of the "by" variables;
\item \eqn{J} is the number of elements of \eqn{\pmb{\beta}};
\item \eqn{U} is the number of elements of \eqn{\pmb{\beta}_u};
\item \eqn{X} is a \eqn{J \times n} or \eqn{V \times n} matrix of
spline basis functions; and
\item \eqn{n} is \code{n_comp}.
}

The elements of \eqn{\pmb{\alpha}} or \eqn{\pmb{alpha}_u} are assumed
to follow a \link[=RW2]{second-order random walk}.
}

\examples{
Sp()
Sp(n_comp = 10)
}
\references{
\itemize{
\item Eilers, P.H.C. and Marx B. (1996).
"Flexible smoothing with B-splines and penalties".
Statistical Science. 11 (2): 89–121.
}
}
\seealso{
\itemize{
\item \code{\link[=RW]{RW()}} Smoothing via random walk
\item \code{\link[=RW2]{RW2()}} Smoothing via second-order random walk
\item \code{\link[=SVD]{SVD()}} Smoothing of age via singular value decomposition
\item \link{priors} Overview of priors implemented in \strong{bage}
\item \code{\link[=set_prior]{set_prior()}} Specify prior for intercept,
main effect, or interaction
\item \strong{bage} uses function \code{\link[splines:bs]{splines::bs()}} to construct
spline basis functions
}
}
