% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_prior-constructors.R
\name{Lin_AR1}
\alias{Lin_AR1}
\title{Linear Prior with Autoregressive Errors of Order 1}
\usage{
Lin_AR1(min = 0.8, max = 0.98, s = 1, sd = 1, along = NULL)
}
\arguments{
\item{min, max}{Minimum and maximum values
for autocorrelation coefficient.
Defaults are \code{0.8} and \code{0.98}.}

\item{s}{Scale for the innovations in the
AR process. Default is \code{1}.}

\item{sd}{Standard deviation in the prior for
the slope of the line. Larger values imply
steeper slopes. Default is 1.}

\item{along}{Name of the variable to be used
as the "along" variable. Only used with
interactions.}
}
\value{
An object of class \code{"bage_prior_linar"}.
}
\description{
Use a line or lines with AR1
errors to model a main effect
or interaction. Typically used with time.
}
\details{
If \code{Lin_AR()} is used with an interaction,
separate lines are constructed along
the "along" variable, within each combination
of the "by" variables.

Arguments \code{min} and \code{max} can be used to specify
the permissible range for autocorrelation.

Argument \code{s} controls the size of the innovations.
Smaller values tend to give smoother estimates.

Argument \code{sd} controls the size of the slopes of
the lines. Larger values can give more steeply
sloped lines.
}
\section{Mathematical details}{


When \code{Lin_AR1()} is being used with a main effect,

\deqn{\beta_j = \eta q_j + \epsilon_j}
\deqn{\epsilon_j = \phi \epsilon_{j-1} + \varepsilon_j,}
\deqn{\varepsilon_j \sim \text{N}(0, \omega^2).}

and when it is being used with an interaction,

\deqn{\beta_{u,v} = \eta_j q_{u,v} + \epsilon_{u,v}}
\deqn{\epsilon_{u,v} = \phi + \varepsilon_{u,v},}
\deqn{\varepsilon_{u,v} \sim \text{N}(0, \omega^2).}

where
\itemize{
\item \eqn{\pmb{\beta}} is the main effect or interaction;
\item \eqn{j} denotes position within the main effect;
\item \eqn{u} denotes position within the "along" variable of the interaction;
\item \eqn{u} denotes position within the "by" variable(s) of the interaction;
\item \eqn{q = - (J+1)/(J-1) + 2j/(J-1);} and
\item \eqn{q_v = - (V+1)/(V-1) + 2v/(V-1)}.
}

The slopes have priors
\deqn{\eta \sim \text{N}(0, \text{sd}^2)}
and
\deqn{\eta_u \sim \text{N}(0, \text{sd}^2).}
Larger values for \code{sd} permit steeper slopes.

Internally, \code{Lin_AR1()} derives a value for \eqn{\omega} that
gives \eqn{\epsilon_j} or \eqn{\epsilon_{u,v}} a marginal
variance of \eqn{\tau^2}. Parameter \eqn{\tau}
has a half-normal prior
\deqn{\tau \sim \text{N}^+(0, \text{s}^2),}
where a value for \code{s} is provided by the user.

Coefficient \eqn{\phi} is constrained
to lie between \code{min} and \code{max}.
Its prior distribution is
\deqn{\phi = (\text{max} - \text{min}) \phi' - \text{min}}
where
\deqn{\phi' \sim \text{Beta}(2, 2).}
}

\examples{
Lin_AR1()
Lin_AR1(min = 0, s = 0.5, sd = 2)
}
\references{
\itemize{
\item The defaults for \code{min} and \code{max} are based on the
defaults for \code{forecast::ets()}.
}
}
\seealso{
\itemize{
\item \code{\link[=Lin_AR]{Lin_AR()}} Generalization of \code{Lin_AR1()}
\item \code{\link[=Lin]{Lin()}} Line with independent normal errors
\item \code{\link[=AR1]{AR1()}} AR1 process with no line
\item \link{priors} Overview of priors implemented in \strong{bage}
\item \code{\link[=set_prior]{set_prior()}} Specify prior for intercept,
main effect, or interaction
}
}
