% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment.R
\name{start_logging_run}
\alias{start_logging_run}
\title{Create an interactive logging run}
\usage{
start_logging_run(experiment, outputs = NULL,
  snapshot_directory = NULL)
}
\arguments{
\item{experiment}{The \code{Experiment} object.}

\item{outputs}{(Optional) A string of the local path to an
outputs directory to track.}

\item{snapshot_directory}{(Optional) Directory to take snapshot of.
Setting to \code{NULL} will take no snapshot.}
}
\value{
The \code{Run} object of the started run.
}
\description{
Create an interactive run that allows the user to log
metrics and artifacts to a run locally.

Any metrics that are logged during the interactive run session
are added to the run record in the experiment. If an output
directory is specified, the contents of that directory is
uploaded as run artifacts upon run completion.

This method is useful if you would like to add experiment
tracking and artifact logging to the corresponding run record
in Azure ML for local runs without have to submit an experiment
run to a compute target with \code{submit_experiment()}.
}
\examples{
\dontrun{
ws <- load_workspace_from_config()
exp <- experiment(ws, name = 'myexperiment')
run <- start_logging_run(exp)
log_metric_to_run("Accuracy", 0.9)
complete_run(run)
}
}
\seealso{
\code{complete_run()}
}
