% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{create_tabular_dataset_from_sql_query}
\alias{create_tabular_dataset_from_sql_query}
\title{Create a TabularDataset to represent tabular data in SQL databases.}
\usage{
create_tabular_dataset_from_sql_query(query, validate = TRUE,
  set_column_types = NULL)
}
\arguments{
\item{query}{A SQL-kind datastore and a query}

\item{validate}{Boolean to validate if data can be loaded from the returned dataset.
Defaults to True. Validation requires that the data source is accessible from
the current compute.}

\item{set_column_types}{A named list to set column data type, where key is
column name and value is data type.}
}
\value{
The Tabular Dataset object
}
\description{
Create a TabularDataset to represent tabular data in SQL databases.
``from_sql_query``` creates a Tabular Dataset object , which defines the operations to
load data from SQL databases into tabular representation. For the data to be accessible
by Azure Machine Learning, the SQL database specified by \code{query} must be located in
a Datastore and the datastore type must be of a SQL kind. Column data types are
read from data types in SQL query result. Providing `set_column_types` will
override the data type  for the specified columns in the returned Tabular Dataset.
}
