% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-stations.R
\name{get_stations}
\alias{get_stations}
\title{Get Station Metadata}
\usage{
get_stations(aoi = NULL, elements, awdb_options = set_options())
}
\arguments{
\item{aoi}{\code{sfc} POLYGON scalar, the area of interest used for performing
a spatial filter on available stations in \code{network}. If \code{NULL} (the default),
no spatial filter is performed.}

\item{elements}{character vector, abbreviations or codes for variables of
interest (e.g., "SMS" for "Soil Moisture Percent"). See Details for available
elements and codes.}

\item{awdb_options}{an \code{awdb_options} list with additional query parameters.}
}
\value{
an \code{sf} table with station metadata.
}
\description{
Get station metadata from the USDA National Water and Climate Center Air and
Water Database REST API. This includes their spatial coordinates.
}
\details{
This endpoint will accept the following query parameters via \code{set_options()}:
\itemize{
\item \code{station_names}
\item \code{dco_codes}
\item \code{county_names}
\item \code{hucs}
\item \code{return_forecast_metadata}
\item \code{return_reservoir_metadata}
\item \code{return_element_metadata}
\item \code{active_only}
}

You may also specify \code{networks}. The \code{networks} parameter is used internally
to build unique station triplet identifiers of the form
\code{station:state:network}, so it serves to filter stations to just those
networks.

See \code{set_options()} for more details.
\subsection{Element Format}{

Elements are specified as triplets of the form
\code{elementCode:heightDepth:ordinal}. Any part of the element triplet can
contain the \code{*} wildcard character. Both \code{heightDepth} and \code{ordinal} are
optional. The unit of \code{heightDepth} is inches. If \code{ordinal} is not specified,
it is assumed to be 1. Here are some examples:
\itemize{
\item \code{"WTEQ"} - return all snow water equivalent values.
\item \code{"SMS:-8"} - return soil moisture values observed 8 inches below the surface.
\item \code{"SMS:*"} - return soil moisture values for all measured depths.
}
}
}
\examples{
# get all stations in aoi
get_stations(
  bear_lake,
  elements = "*"
)

# get all stations in aoi that measure WTEQ
get_stations(
  bear_lake,
  elements = "WTEQ"
)

# get all stations in aoi that are part of SNTL network
get_stations(
  bear_lake,
  elements = "*",
  awdb_options = set_options(networks = "SNTL")
)

}
