% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_phenotype_id_from_transcriptome_id.R
\name{get_phenotype_id_from_transcriptome_id}
\alias{get_phenotype_id_from_transcriptome_id}
\title{Get phenotype from transcriptome}
\usage{
get_phenotype_id_from_transcriptome_id(
  transcriptome_id,
  seed_id = FALSE,
  phenotype_binary = FALSE
)
}
\arguments{
\item{transcriptome_id}{Integer or list of integer values.}

\item{seed_id}{Integer (from 1 to 1000), a vector of integer values, or a
logical value. This integer is used for starting the pseudo-random number
generator that represents the environment experiencing a digital organism.
If a logical value is used, TRUE returns data found in all environments and
FALSE (by default) returns only distinct data regardless of the seed.}

\item{phenotype_binary}{Logical value (TRUE/FALSE) to show/hide phenotype in
binary notation (FALSE by default).}
}
\value{
Data frame. Columns: "seed_id" (optional),	"transcriptome_id",	"phenotype_id", "phenotype_binary" (optional)
}
\description{
Get the phenotype encoded by the genome of a digital organism that executes a specific transcriptome for a list of seeds used for starting the pseudo-random number generator (i.e., a set of environments).
}
\examples{

# Single transcriptome
get_phenotype_id_from_transcriptome_id(transcriptome_id = 53674)

# More than one transcriptome
get_phenotype_id_from_transcriptome_id(
  transcriptome_id = c(53674, 1666099),
  phenotype_binary = TRUE
)

# At seed_1 and seed_3
get_phenotype_id_from_transcriptome_id(transcriptome_id = 53674, seed_id = c(1,3))

}
