% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_genome_id_from_transcriptome_id.R
\name{get_genome_id_from_transcriptome_id}
\alias{get_genome_id_from_transcriptome_id}
\title{Get genome from transcriptome}
\usage{
get_genome_id_from_transcriptome_id(
  transcriptome_id,
  seed_id = FALSE,
  genome_seq = FALSE
)
}
\arguments{
\item{transcriptome_id}{Integer or a list of integer values.}

\item{seed_id}{Integer (from 1 to 1000), a vector of integer values, or a
logical value. This integer is used for starting the pseudo-random number
generator that represents the environment experiencing a digital organism.
If a logical value is used, TRUE returns data found in all environments and
FALSE (by default) returns only distinct data regardless of the seed.}

\item{genome_seq}{Logical value (TRUE/FALSE) to show/hide this column
("FALSE" by default).}
}
\value{
Data frame. Columns: "seed_id" (optional), "transcriptome_id",
"genome_seq" (optional).
}
\description{
Get the genome of a digital organism that executes a specific
transcriptome for a list of seeds used for starting the pseudo-random number
generator (i.e., a set of environments).
}
\examples{

# Single transcriptome
get_genome_id_from_transcriptome_id(transcriptome_id = 1)

# More than one transcriptome
get_genome_id_from_transcriptome_id(
  transcriptome_id = c(1, 2, 3),
  genome_seq = TRUE
)

# At seed_1 and seed_2
get_genome_id_from_transcriptome_id(
  transcriptome_id = 1,
  seed_id = c(1, 2)
)

}
