% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{avar_mo_cpp}
\alias{avar_mo_cpp}
\title{Compute Maximal-Overlap Allan Variance using Means}
\usage{
avar_mo_cpp(x)
}
\arguments{
\item{x}{A \code{vector} with dimensions N x 1.}
}
\value{
av A \code{list} that contains:
\itemize{
 \item{"clusters"}{The size of the cluster}
 \item{"allan"}{The Allan variance}
 \item{"errors"}{The error associated with the variance estimation.}
}
}
\description{
Computation of Maximal-Overlap Allan Variance
}
\details{
Given \eqn{N} equally spaced samples with averaging time \eqn{\tau = n\tau _0}{tau = n*tau_0},
where \eqn{n} is an integer such that \eqn{ 1 \le n \le \frac{N}{2}}{1<= n <= N/2}.
Therefore, \eqn{n} is able to be selected from \eqn{\left\{ {n|n < \left\lfloor {{{\log }_2}\left( N \right)} \right\rfloor } \right\}}{{n|n< floor(log2(N))}}
Then, \eqn{M = N - 2n} samples exist.
The Maximal-overlap estimator is given by:
\eqn{\frac{1}{{2\left( {N - 2k + 1} \right)}}\sum\limits_{t = 2k}^N {{{\left[ {{{\bar Y}_t}\left( k \right) - {{\bar Y}_{t - k}}\left( k \right)} \right]}^2}} }

where \eqn{ {{\bar y}_t}\left( \tau  \right) = \frac{1}{\tau }\sum\limits_{i = 0}^{\tau  - 1} {{{\bar y}_{t - i}}} }.
}
\examples{
\donttest{
set.seed(999)
N = 100000
white.noise = rnorm(N, 0, 2)
random.walk = cumsum(0.1*rnorm(N, 0, 2))
combined.ts = white.noise+random.walk
av_mat = avar_mo_cpp(combined.ts)
}
}
\references{
Long-Memory Processes, the Allan Variance and Wavelets, D. B. Percival and P. Guttorp
}
\author{
JJB
}
\keyword{internal}
