% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_correlation_matrix.r
\name{print_correlation_matrix}
\alias{print_correlation_matrix}
\title{Print the correlation matrix of the residuals of a model annotated with p-values}
\usage{
print_correlation_matrix(varest)
}
\arguments{
\item{varest}{A \code{varest} model.}
}
\value{
This function returns the annotated correlation matrix.
}
\description{
This function prints the correlation matrix of residuals of a model annotated with p-values. This is a lower triangular matrix, in the way that all elements in the upper triangular matrix are \code{NA} and the elementals on the "diagonal" are \code{1} (note that there is not really a diagonal because the matrix is rectangular). The odd rows of the returned matrix contain the correlations while the even rows are the associated p-values. For each correlation in row \code{x}, column \code{y}, its p-value is located in row \code{x+1}, column {y}.
}
\examples{
data_matrix <- matrix(nrow = 40, ncol = 3)
data_matrix[, ] <- runif(ncol(data_matrix) * nrow(data_matrix), 1, nrow(data_matrix))
colnames(data_matrix) <- c('rumination', 'happiness', 'activity')
varest <- autovarCore:::run_var(data_matrix, NULL, 1)
autovarCore::print_correlation_matrix(varest)
}
