% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_score.r
\name{model_score}
\alias{model_score}
\title{Return the model fit for the given varest model}
\usage{
model_score(varest, criterion, logtransformed)
}
\arguments{
\item{varest}{A \code{varest} model.}

\item{criterion}{A character string being either \code{'AIC'} or \code{'BIC'}.}

\item{logtransformed}{A boolean, either \code{TRUE} or \code{FALSE}, indicating whether the input data for the model has been logtransformed.}
}
\value{
This returns a floating point that is either the AIC or BIC criterion for the model. A lower number corresponds to a better model fit.
}
\description{
This function returns the model fit for the given model as either an AIC or BIC score. We compensating for logtransformation so that the model scores of logtransformed and non-logtransformed models can be compared with each other directly. This compensation is implemented by subtracting the logtransformed data from the log-likelihood score and using the result as log-likelihood score for the AIC/BIC calculations.
}
\examples{
data_matrix <- matrix(nrow = 40, ncol = 3)
data_matrix[, ] <- runif(ncol(data_matrix) * nrow(data_matrix), 1, nrow(data_matrix))
colnames(data_matrix) <- c('rumination', 'happiness', 'activity')
varest <- autovarCore:::run_var(data_matrix, NULL, 1)
autovarCore:::model_score(varest, 'AIC', FALSE)
}
