# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Get the means/medians/variances of pillars of a 3d array
#'
#' For a 3-dimensional array \code{arr3d}, pillar \code{ij} is defined as
#' \code{arr3d[i, j, ]}. These functions compute the mean, median and variance of each
#' pillar.
#'
#' @param arr3d A 3-dimensional array.
#'
#' @return A matrix where element \code{i,j} is equal to \code{mean(arr3d[i, j, ])},
#' \code{median(arr3d[i, j, ])}, or \code{var(arr3d[i, j, ])}.
#'
#' @examples
#' m3 <- array(1:16, dim = c(2, 2, 4))
#' mean_pillars(m3)
#' median_pillars(m3)
#' var_pillars(m3)
#'
#' @export
mean_pillars <- function(arr3d) {
    .Call('autothresholdr_mean_pillars', PACKAGE = 'autothresholdr', arr3d)
}

#' @rdname mean_pillars
#' @export
var_pillars <- function(arr3d) {
    .Call('autothresholdr_var_pillars', PACKAGE = 'autothresholdr', arr3d)
}

#' @rdname mean_pillars
#' @export
median_pillars <- function(arr3d) {
    .Call('autothresholdr_median_pillars', PACKAGE = 'autothresholdr', arr3d)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('autothresholdr_RcppExport_registerCCallable', PACKAGE = 'autothresholdr')
})
