% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_correctness.R
\name{check_correctness}
\alias{check_correctness}
\title{Check correctness of student solution rmd.}
\usage{
check_correctness(e_stud, e_soln, test_fname)
}
\arguments{
\item{e_stud}{The environment containing the output objects from running the
studnent Rmd file.}

\item{e_soln}{The environment containing the objects from the solution
template. It will probably contain objects with the suffix "_soln". These
will be tested against the versions generated by the student.}

\item{test_fname}{The R script containing the test chunks.}
}
\value{
A data frame with one row, and the number of columns equal to the 
number of tests run plus the number of scalars to keep.
}
\description{
This will run unit tests on the students' rmd file.
}
\details{
Prior to calling this, \code{\link{populate_soln_env}} should 
already have been called on the solution template, and the student 
file should already have been knitted in order to generate the students' 
objects. Of course, one could generate the test script independent of 
\code{\link{populate_soln_env}}, but the solution environment that contains 
objects with a "_soln" suffix is also needed.

The student environment, solution environment, test file and the list of 
tests and expectations are the inputs to this function.
}
\seealso{
\code{\link{populate_soln_env}}, \code{\link{render_one}}
}
