% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rsiena.R
\name{plot.selectionTable}
\alias{plot.selectionTable}
\title{Plotting selection tables}
\usage{
\method{plot}{selectionTable}(x, quad = TRUE, separation = 0, ...)
}
\arguments{
\item{x}{An object of class "selectionTable",
created using \code{RSiena::selectionTable()}.}

\item{quad}{When TRUE (the default), a quadratic function
(average and total alter) is plotted.
Use \code{quad = FALSE} for similarity effects.}

\item{separation}{This can be used to make the curves visually distinguishable
if they overlap too much without it.
An advisable value then is, e.g., 0.01.}

\item{...}{Other arguments to be passed.}
}
\value{
A plot showing how the selection evaluation function changes based
on ego's value and alter's value of some covariate.
}
\description{
These are functions for constructing and presenting selection tables
for the interpretation of results for network dynamics obtained with
the RSiena package.
}
\examples{
plot(res_siena_selection)
}
\references{
Consult also the RSiena manual, Sections 13.1 and 13.3.
}
\author{
Tom Snijders
}
