% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_vs.R
\name{best_vs}
\alias{best_vs}
\title{The Combination of Two Bins Produces the Best Binning Result}
\usage{
best_vs(df1, df2, variable = "variable", label_iv = "miv")
}
\arguments{
\item{df1}{A binned data.}

\item{df2}{A binned data.}

\item{variable}{A name of X variable.}

\item{label_iv}{A name of target variable.}
}
\value{
A data frame of best IV.
}
\description{
The Combination of Two Bins Produces the Best Binning Result
}
\examples{
accepts <- read.csv(system.file( "extdata", "accepts.csv", package = "autoScorecard" ))
feature <- stats::na.omit( accepts[,c(1,3,7:23)] )
all2 <- bins_tree(df = feature, key_var= "application_id", y_var= "bad_ind"
, max_depth = 3, p = 0.1 )
f_1 <-bins_unsupervised(  df = feature , id="application_id" , label="bad_ind" ,
methods = c("k_means", "equal_width","equal_freq"  )  ,  bin_nums=10  )
best1 <- best_iv( df=f_1 ,bin=c('bins') ,  method = c('method') ,
variable= c( "variable" )  ,label_iv='miv'  )
vs1 <- best_vs( df1 = all2[,-c(3)], df2 = best1[,-c(1:2)] ,variable="variable" ,label_iv='miv' )
}
