% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{model_list}
\alias{model_list}
\title{A list of models for the best subset selection.}
\usage{
model_list(y, L1.x, L2.x, L2.unit, L2.reg = NULL)
}
\arguments{
\item{y}{Outcome variable. A character vector containing the column names of
the outcome variable.}

\item{L1.x}{Individual-level covariates. A character vector containing the
column names of the individual-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}. Note that geographic unit
is specified in argument \code{L2.unit}.}

\item{L2.x}{Context-level covariates. A character vector containing the
column names of the context-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}.}

\item{L2.unit}{Geographic unit. A character scalar containing the column name
of the geographic unit in \code{survey} and \code{census} at which outcomes
should be aggregated.}

\item{L2.reg}{Geographic region. A character scalar containing the column
name of the geographic region in \code{survey} and \code{census} by which
geographic units are grouped (\code{L2.unit} must be nested within
\code{L2.reg}). Default is \code{NULL}.}
}
\value{
Returns a list with the number of elements equal to 2^k where k is
  the number context-level variables. Each element is of class formula.
}
\description{
\code{model_list()} generates an exhaustive list of lme4 model formulas from
the individual level and context level variables as well as geographic unit
variables to be iterated over in best subset selection.
}
