% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_connection.R
\name{set_connection}
\alias{set_connection}
\title{Set up parameters of a connection with ATSD.}
\usage{
set_connection(url = NA, user = NA, password = NA, verify = NA,
  encryption = NA, file = NA)
}
\arguments{
\item{url}{Optional string argument. The url of ATSD with the port number.}

\item{user}{Optional string argument. The user name.}

\item{password}{Optional string argument. The user's password.}

\item{verify}{Optional string argument -- "yes" or "no". 
\code{verify = "yes"}  ensures validation of ATSD SSL certificate and 
\code{verify = "no"}  suppresses the validation 
(applicable in the case of 'https' protocol).}

\item{encryption}{Optional string argument.
Cryptographic protocol used by ATSD https server. 
Possible values are: "default", "ssl2", "ssl3", and "tls1" 
(In most cases, use "ssl3" or "tls1".)}

\item{file}{Optional string argument.
The absolute path to the file from which the connection parameters could be read. 
The file should be formatted as the package configuration file, 
see the Details section below.}
}
\description{
The function overrides the connection parameters
    for the duration of the current R session without changing the configuration file.
}
\details{
The function overrides the connection parameters for the duration 
    of the current R session without changing the configuration file. 
    If called without arguments the function sets the connection parameters 
    from the configuration file. If the file  argument is provided the function use it. 
    In both cases the current values of the parameters became the same as in the file. 
    The file should be a plain text file formatted as the following:
     
     \code{# the url of ATSD including port number}
     \cr
     \code{url=http://host_name:port_number}
     \cr
     \code{# the user name}
     \cr
     \code{user=atsd_user_name}
     \cr
     \code{# the user's password}
     \cr
     \code{password=atsd_user_password}
     \cr
     \code{# validate ATSD SSL certificate: yes, no}
     \cr
     \code{verify=no}
     \cr
     \code{# cryptographic protocol used by ATSD https server:}
     \cr
     \code{# default, ssl2, ssl3, tls1}
     \cr
     \code{encryption=ssl3}
     
    In case the \code{file}  argument is not provided, but some of other arguments are specified, 
    the only specified parameters will be changed.
}
\examples{
# Modify the user
set_connection(user = "user001")

# Modify the cryptographic protocol
set_connection(encryption = "tls1")

# Set up url, user and password
set_connection(url = "http://my.company.com:8088", user = "user001", password = "123456")
    
# Set up parameters of https connection
set_connection(url = "https://my.company.com:8443", user = "user001", password = "123456", 
               verify = "no", encryption = "ssl3")

\dontrun{
# Set up parameters from a file
set_connection(file = "/home/user001/atsd_https_connection.txt")
 
# Set up parameters from the configuration file
set_connection()
}
    
}
\seealso{
To see the current values of the connection parameters use
    the \code{\link{show_connection}} function.
    To change the configuration file use
    the \code{\link{save_connection}} function.
}
