% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indent_data_frame.R
\name{indent_data_frame}
\alias{indent_data_frame}
\title{Indents data.frames}
\usage{
indent_data_frame(
  DD,
  keys,
  values = setdiff(colnames(DD), keys),
  character_empty = "",
  numeric_empty = NA,
  indent_character = "\\\\quad",
  colname_indent = "Group"
)
}
\arguments{
\item{DD}{A data.frame. Should be sorted by \code{keys} with \code{keys[1]} varying slowest and \code{keys[length(keys)]} varying fastest.}

\item{keys}{A character. Subset of \code{colnames(DD)} with \code{length(keys)>=2}. The combination of keys must be unique. \code{DD[keys]} must be class character or factor.}

\item{values}{A character. Subset of colnames(DD). DD[keys] must be class character, factor or numeric.}

\item{character_empty}{A character. Default ''. This character will be put in the new lines in class character columns.}

\item{numeric_empty}{A numeric. Default NA.  This character will be put in the new lines in class numeric columns.}

\item{indent_character}{A character. character for one indent. Default is '\\quad' (meant for latex). Can also be '   ' for Word.}

\item{colname_indent}{A character. Default 'Group'. Name of the new column with the indented keys.}
}
\value{
A data.frame. Columns: \code{c(colname_indent, values)}.
Column \code{colname_indent} contains all combination of \code{DD[keys]}, but now indented and squeezed in this column and casted to character.
Columns \code{'values'} contain all values of \code{DD[values]} unchanged.
Number of rows is \code{sum(cumprod(nlevels(DD[keys])))}.
}
\description{
Indents data.frames for printing them as tables.
}
\details{
Squeeze multiple key-columns into one column and indents the values accordingly.
Adds new lines with the indented keys to the data.frame.
Meant for wide tables that need to be narrower and more 'readable'
Meant for plotting with e.g. xtable::xtable or Hmisc::latex or officer::body_add_table.
Look at the examples for a more precise description.
Meant for left-aligned columns. Thats why the \code{indent_character} is inserted
to the left of the original values.
}
\examples{

DD <- expand.grid(Arm = paste0('Arm ', c(1,2,4)),
                Gender = c('Male', 'Female'),
                Haircolor = c('Red', 'Green', 'Blue'),
                Income = c('Low', 'Med', 'High'), stringsAsFactors = TRUE)

DD <- doBy::orderBy(~ Arm + Gender + Haircolor + Income, DD)

DD$values1 <- runif(dim(DD)[1])
DD$values2 <- 1
DD$values3 <- sample(letters[1:4], size = nrow(DD), replace = TRUE)

keys = c('Arm', 'Gender', 'Haircolor', 'Income')
values = c('values1', 'values2', 'values3')
\dontrun{
DDD <- indent_data_frame(DD, keys, indent_character = '   ')

# print both:

Hmisc::latex(DD,
      file = '',
      longtable = TRUE,
      caption = 'Original table',
      rowname = NULL)

Hmisc::latex(DDD,
      file = '',
      longtable = TRUE,
      caption = 'Indented table',
      rowname = NULL)
      }
}
