% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_alias_mapping.R
\name{create_alias_mapping}
\alias{create_alias_mapping}
\title{Get Aliases of column names}
\usage{
create_alias_mapping(DD, ...)
}
\arguments{
\item{DD}{A data.frame}

\item{...}{Passed from and to other methods.}
}
\value{
\code{create_alias_mapping} returns a data.frame with two columns \code{old} and \code{new} and
as many rows as \code{DD} has columns. Column \code{old} contains the original column names of
\code{DD} and column \code{new} their aliases.
}
\description{
Column names of data.frame in atable must have syntactically valid colnames,
see \code{\link[atable]{is_syntactically_valid_name}}.
So no blanks or special characters allowed.
But Reporting in human readable language needs special characters.
These functions here allow atable to handle arbitrary character for pretty printing.
}
\details{
We use \code{\link[base]{attributes}} here, to assign alternative names to columns.
Also class \code{labelled} created by Hmisc's \code{\link[Hmisc]{label}} is supported.

See \code{create_alias_mapping} for the function that does the actual work.

If no aliases are found, then underscores in the column names of \code{DD} will be replaced by blanks.
See Examples in \code{?atable}.
}
