% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream.R
\name{stream}
\alias{stream}
\title{Create an asynchronous iterator by writing sequential code.}
\usage{
stream(
  expr,
  ...,
  split_pipes = TRUE,
  lazy = TRUE,
  trace = trace_,
  compileLevel = getOption("async.compileLevel"),
  debugR = FALSE,
  debugInternal = FALSE
)
}
\arguments{
\item{expr}{A coroutine expression, using some combination of
\code{yield}, \code{await}, \code{awaitNext}, \code{yieldFrom}, standard control flow
operators and other calls.}

\item{...}{Undocumented.}

\item{split_pipes}{See description under \link{async}; defaults to
\code{TRUE}.}

\item{lazy}{If TRUE, start paused, and pause after \code{yield()} (see above.)}

\item{trace}{An optional tracing function.}

\item{compileLevel}{Compilation level.}

\item{debugR}{Set TRUE to single-step debug at R level. Use \code{\link[=debugAsync]{debugAsync()}}
to enable or disable debugging on a stream after it has been created.}

\item{debugInternal}{Set TRUE to single-step debug at coroutine
implementation level.}
}
\value{
An object with (at least) classes "stream", "channel",
"coroutine", "iteror", "iter".
}
\description{
(Experimental as of async 0.4.) \code{stream(...)} constructs a \link{channel}
object, i.e. an asynchronous iterator, which will compute and
return values according to sequential code written in \code{expr}. A
\code{stream} is a coroutine wearing a \link{channel} interface in the same
way that \code{async} is a coroutine wearing a \link{promise} interface, and a
\link{gen} is a coroutine sitting behind an \link{iteror} interface.
}
\details{
In a stream expression, you can call \code{yield()} to emit a value, and
\code{await()} to wait for a value from a \link{promise}. To have your stream
wait for values from another stream or \link{channel}, call
\code{awaitNext()}; you can also use \code{awaitNext} when you are writing an
\code{async}. You can also use a simple \code{for} loop to consume all future
values from a stream or channel.

The lower-level interface to consume values from a stream is by using
\link{nextThen} from the \link{channel} interface.

Streams come in both "lazy" and "eager" varieties. If \code{lazy=TRUE},
a stream starts idle, and does not process anything
until it is woken up by a call to its channel's \code{nextThen}. It will
pause after reaching \code{yield} if there are no more outstanding
requests. If \code{lazy=FALSE}, a stream will begin executing
immediately, not pausing on \code{yield}, possibly queuing up emitted
values until it needs to \code{await} something.

(For comparison, in this package, \link{gen} are lazy in that they do
not start executing until a call to \code{nextOr} and pause
immediately after \code{yield}, while \link{async} blocks are eager,
starting at construction and running until they hit an \code{await}.)

Like its coroutine counterparts, if \code{stream} is given a function
expression, like \code{stream(function(...)  ...)}, it will return a
"stream function" i.e. a function that constructs a stream object.
}
\examples{

# emit values _no more than_ once per second
count_to <- stream(function(n, interval=1) {
  for (i in 1:n) {
    await(delay(interval))
    yield(i)
  }
})

accumulate <- stream(function(st, sum=0) {
  for (i in st) {sum <- sum + i; yield(sum)}
})

print_each <- async(function(st) for (i in st) print(i))

count_to(10) |> accumulate() |> print_each()

}
\author{
Peter Meilstrup
}
