% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/channel.R
\name{nextThen}
\alias{nextThen}
\alias{subscribe}
\title{Receive values from channels by callback.}
\usage{
nextThen(x, onNext, onError, onClose, ...)

subscribe(x, ...)
}
\arguments{
\item{x}{A \link{channel} object}

\item{onNext}{For \link{nextThen}, a function to be called with the next
emitted value. For \link{subscribe}, a function to be called with each
emitted value until the stream finishes.}

\item{onError}{Function to be called if channel stops with an
error. Note that if you call nextThen multiple times to register
multile callbacks, only the first will receive onError; the rest
will be called with onClose.}

\item{onClose}{Function to be called if the channel finishes normally.}

\item{...}{Undocumented.}
}
\description{
\code{nextThen} is the callback-oriented interface to work with
\link{channel} objects. Provide the channel callback functions to
receive the next element, error, and closing signals; your
callbacks will be stored in a queue and called when values are
available.
}
\details{
\code{subscribe} is similar to nextThen except that your \code{onNext} will be
called for each value the channel emits. It is just implemented
in terms of nextThen, with a callback that re-registers itself.
}
