% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule.R
\name{pattern_rule}
\alias{pattern_rule}
\title{Build a pattern rule}
\usage{
pattern_rule(selector = NULL, context = NULL, strictness = "smart")
}
\arguments{
\item{selector}{Defines the surrounding code that helps to resolve any
ambiguity in the syntax.}

\item{context}{Defines the sub-syntax node kind that is the actual matcher
of the pattern.}

\item{strictness}{Optional, defines how strictly pattern will match against
nodes. See 'Details'.}
}
\value{
An list of class \code{astgrep_pattern_rule}
}
\description{
This is a specific type of rule. It can be used in the more general ruleset
built with \code{ast_rule()}.
}
\details{
The \code{strictness} parameter defines the type of nodes the \code{ast-grep} matcher
should consider. It has the following values:
\itemize{
\item \code{cst}: All nodes in the pattern and target code must be matched. No node
is skipped.
\item \code{smart}: All nodes in the pattern must be matched, but it will skip unnamed
nodes in target code. This is the default behavior.
\item \code{ast}: Only named AST nodes in both pattern and target code are matched.
All unnamed nodes are skipped.
\item \code{relaxed}: Named AST nodes in both pattern and target code are matched.
Comments and unnamed nodes are ignored.
\item \code{signature}: Only named AST nodes' kinds are matched. Comments, unnamed
nodes and text are ignored.
}

More information: \url{https://ast-grep.github.io/guide/rule-config/atomic-rule.html#pattern-object}
}
