% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/engine.R
\name{assert_engine}
\alias{assert_engine}
\title{Throws an error if a condition isn't met.}
\usage{
assert_engine(x, predicate, msg, what = c("all", "any"), ...)
}
\arguments{
\item{x}{Input to check.  If missing, pass no args to \code{predicate}.}

\item{predicate}{Function that returns a logical value (possibly
a vector).}

\item{msg}{The error message, in the event of failure.}

\item{what}{Either 'all' or 'any', to reduce vectorised tests to a
single value.}

\item{...}{Passed to the \code{predicate} function.}
}
\value{
\code{FALSE} with the attribute \code{message}, as provided
in the input.
}
\description{
The workhorse of the package.  If a condition isn't met, then an error
is thrown.  This function is exported for use by package developers so
that they can create their own assert functions.
}
\note{
Missing values are considered as \code{FALSE} for the purposes of
whether or not an error is thrown.
}
\examples{
# Extending assertive with an is function that returns a single value
is_identical_to_pi <- function(x, .xname = get_name_in_parent())
{
  if(!identical(x, pi))
  {
    return(false("\%s is not identical to pi", .xname))
  }
  TRUE
}
assert_is_identical_to_pi <- function(x, .xname = get_name_in_parent())
{
  assert_engine(
    x,
    is_identical_to_pi,
    .xname = get_name_in_parent(x)
  )
}

is_identical_to_pi(pi)
is_identical_to_pi(3)
assert_is_identical_to_pi(pi)
dont_stop(assert_is_identical_to_pi(3))

# Extending assertive with an is function that returns a vector
is_less_than_pi <- function(x)
{
  is_in_right_open_range(x, upper = pi)
}

assert_all_are_less_than_pi <- function(x)
{
  msg <- gettextf("\%s are not all less than pi.", get_name_in_parent(x))
  assert_engine(
    x,
    is_less_than_pi,
    msg
  )
}
assert_any_are_less_than_pi <- function(x)
{
  msg <- gettextf("\%s are all greater than or equal to pi.", get_name_in_parent(x))
  assert_engine(
    x,
    is_less_than_pi,
    msg,
    what = "any"
  )
}

x <- c(3, pi, 4, NA)
is_less_than_pi(x)
assert_any_are_less_than_pi(x)
dont_stop(assert_all_are_less_than_pi(x))
}

