% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/utils.R
\name{parenthesize}
\alias{parenthesise}
\alias{parenthesize}
\title{Wrap a string in brackets}
\usage{
parenthesize(x, type = c("round_brackets", "square_brackets",
  "curly_brackets", "angle_brackets", "chevrons", "hyphens", "en_dashes",
  "em_dashes", "commas"))

parenthesise(x, type = c("round_brackets", "square_brackets",
  "curly_brackets", "angle_brackets", "chevrons", "hyphens", "en_dashes",
  "em_dashes", "commas"))
}
\arguments{
\item{x}{Character vector to wrap in parenthenses.}

\item{type}{String naming the type of parenthesis.}
}
\value{
A character vector of the input wrapped in parentheses.
}
\description{
Parenthesise a character vector by wrapping elements in brackets,
dashes or commas.
}
\note{
English grammar terminology is awfully confusing.  The verb 'to
parenthesise' means to wrap a phrase in brackets or dashes or commas,
thus denoting it as supplementary material that could be left out.
A 'parenthesis' as a noun is often used as a synonym for a round bracket.
}
\examples{
paste("There were three", parenthesise(3), "mice in the experiment.")
paste(
  "I love parmos",
  parenthesise("Teesside's finest culinary invention", "en_dashes"),
  "but they are sure to give me heart disease."
)
parenthesise(letters[1:5], "curly")
paste0(
  "The R language",
  parenthesise("an offshoot of S and Scheme", "commas"),
  "is quite good for data analysis."
)
}
\seealso{
\code{\link[base]{sQuote}}
}

