% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-has-dims.R, R/has-dims.R
\name{assert_has_dims}
\alias{assert_has_dims}
\alias{has_dims}
\title{Does the input have dimensions?}
\usage{
assert_has_dims(x, severity = getOption("assertive.severity", "stop"))

has_dims(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{has_dims} returns\code{TRUE} if \code{dim} is non-null.
\code{assert_has_dims} returns nothing but throws an error if
\code{has_dims} is not \code{TRUE}.
}
\description{
Checks to see if the input has dimensions.
}
\seealso{
\code{\link[base]{dim}}, \code{\link{is_of_dimension}}.
}

