% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-infinity-nan.R, R/is-infinity-nan.R
\name{assert_all_are_nan}
\alias{assert_all_are_nan}
\alias{assert_all_are_not_nan}
\alias{assert_any_are_nan}
\alias{assert_any_are_not_nan}
\alias{is_nan}
\alias{is_not_nan}
\title{Is the input (not) NaN?}
\usage{
assert_all_are_nan(x, severity = getOption("assertive.severity", "stop"))

assert_any_are_nan(x, severity = getOption("assertive.severity", "stop"))

assert_all_are_not_nan(x, severity = getOption("assertive.severity", "stop"))

assert_any_are_not_nan(x, severity = getOption("assertive.severity", "stop"))

is_nan(x, .xname = get_name_in_parent(x))

is_not_nan(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_nan} wraps \code{is.nan}, coercing the input to
numeric if necessary.  \code{is_not_nan} works similarly, but returns
the negation.  The \code{assert_*} functions return nothing but
throw an error if the corresponding \code{is_*} function returns
\code{FALSE}.
}
\description{
Checks to see if the input is a number that is(n't) NaN.
}
\examples{
x <- c(0, NaN, NA)
is_nan(x)
is_not_nan(x)
assert_all_are_not_nan(1:10)
assert_any_are_not_nan(x)
assertive.base::dont_stop(assert_all_are_not_nan(x))
}
\seealso{
\code{\link[base]{is.nan}}
}

