\name{pickLSDstatistics.alldiffs}
\alias{pickLSDstatistics.alldiffs}
\alias{pickLSDstatistics}
\title{Pick LSDstatistics whose values minimize the number of errors in pairwise comparisons of predictions.}
\description{Given an \code{\link{alldiffs.object}} with an \code{sed} component, 
             \code{\link{exploreLSDs.alldiffs}} is used to calculate the LSD values for each set of 
             prediction comparisons specified by \code{LSDtype} and \code{LSDby} using each of the 
             statistics \code{minimum}, \code{q10}, \code{q25},  \code{mean}, \code{median}, \code{q75}, 
             \code{q90}  and \code{maximum}. Then the numbers of false positives and 
             false negatives resulting from employing each of the calculated LSDs is obtained. For 
             each set of comparisons, the LSD value(s) with the lowest number of false positives are 
             identified and, from these, the smallest value with the lowest number of false negatives. 
             That is, a conservative approach is taken to picking LSD values by putting the priority on 
             avoiding false positives. Before using the LSDstatistics that this function suggests, the number 
             of false positives and negatives generated by them should be checked. For example, it may be 
             that there are too many false negatives and a better balance between the numbers of false 
             positives and negatives can be identified using \code{\link{exploreLSDs.alldiffs}},}
\usage{
\method{pickLSDstatistics}{alldiffs}(alldiffs.obj, 
                  LSDtype = "overall", LSDby = NULL, 
                  alpha = 0.05, digits = 3, 
                  false.pos.wt = NULL, retain.zeroLSDs = FALSE, 
                  zero.tolerance = .Machine$double.eps ^ 0.5, 
                  ...)}
\arguments{
\item{alldiffs.obj}{An \code{\link{alldiffs.object}}.}
\item{LSDtype}{A \code{\link{character}} string that can be \code{overall} or \code{factor.combinations}. 
              It determines whether the LSD values that are investigated and stored are  
              (i) the \code{overall} minimum, quantile10, quantile25, mean, median, quantile75, quantile90, 
              and maximum of all pairwise LSDs, or 
              (ii) the minimum, quantile10, quantile25, mean, median, quantile75, quantile90, and maximum 
              for the pairwise LSDs for each combination of the values of the \code{\link{factor}s} and 
              \code{\link{numeric}s} named in \code{LSDby}, unless there is only one prediction for a 
              combination, when notional LSDs are calculated. The \code{LSDtype} specified here does not 
              have to match that used in the creating the \code{\link{alldiffs.object}}.
             
              See \code{\link{LSD.frame}} for further information on how the LSD statistics are calculated.}
\item{LSDby}{A \code{\link{character}} (vector) of variables names, being the names of the 
             \code{\link{factor}s} or \code{\link{numeric}s} in the \code{classify}; for each 
             combination of the values the of the \code{\link{factor}s} and \code{\link{numeric}s}, the 
             LSD errors are to be computed when \code{LSDtype} is \code{factor.combinatons}. The \code{LSDby} 
             specified here does not have to match that used in the creating the 
             \code{\link{alldiffs.object}}.}
\item{alpha}{A \code{\link{numeric}} specifying the significance level for an LSD to compare a pair of 
            predictions.}
\item{digits}{A \code{\link{numeric}} specifying the number of significant digits to retain in rounding 
            the LSDs before determining the distinct rounded LSDs.}
\item{false.pos.wt}{When it is not \code{NULL}, it should be a \code{\link{numeric}} that specifies the 
            weight (e.g. 3 so that a false positive is considered to be equivalent to three false negatives) 
            to apply to the number of false positives in calculating the weighted sums of the numbers of 
            false positives and negatives to use in comparing different LSD statistics, one being the weight 
            for the number false negatives. The \code{LSDstatistic} that is chosen for making comparisons 
            will be the one that minimizes the weighted sum, has the smallest number of false positives and, 
            amongst these, has the smallest LSD value. If it is \code{NULL}, the \code{LSDstatistic} that 
            will be chosen is the one that minimizes the number of false negatives from amongst those that 
            minimize the number of false positives. 

            If, amongst the LSD statistices, the least number of  false negatives that occurs is \emph{m}, 
            then for a particular statistic with \emph{p} the number of false positives, \emph{n} the number 
            of false negatives and \emph{w} the value of \code{false.pos.wt},  that statistic will be a 
            candidate LSD value if \eqn{(w p) + n < m}{(w p) + n < m} and i.e. 
            if \eqn{p < (m - n) / w}{p < (m - n) / w}.}
\item{retain.zeroLSDs}{A \code{\link{logical}} indicating whether to retain or omit LSDs that are zero when 
             calculating the summaries of LSDs.}
\item{zero.tolerance}{A \code{\link{numeric}} specifying the value such that if an LSD is less than it, the LSD will be 
            considered to be zero.}
\item{\dots}{Provision for passing arguments to functions called internally - 
            not used at present.}
}
\value{A \code{\link{character}} of length one for \code{LSDby} set to \code{overall} or of length equal to the 
             number of observed combinations of the values of the \code{\link{factor}s} and \code{\link{numeric}s} 
             in \code{LSDby}. Each element of the returned \code{\link{character}} is one of \code{minimum}, 
             \code{q10}, \code{q25},  \code{mean}, \code{median}, \code{q75}, \code{q90} or \code{maximum}, 
             reflecting the value(s) of the LSD from amongst those calculated that minimizes the number of false 
             positives; if there is more than one such value, then the element will be correspond to the value 
             of the LSD from amongst those with the minimum number of false positives that minimizes 
             the number of false negatives.
}


\author{Chris Brien}
\seealso{\code{\link{asremlPlus-package}}, \code{\link{exploreLSDs.alldiffs}} \code{\link{plotLSDs.data.frame}}, 
         \code{\link{plotLSDs.alldiffs}}, \cr 
         \code{\link{plotLSDerrors.alldiffs}}, \code{\link{plotLSDerrors.data.frame}}, \code{\link{recalcLSD.alldiffs}}, \cr 
         \code{\link{redoErrorIntervals.alldiffs}}}
\examples{
data(WaterRunoff.dat)

##Use asreml to get predictions and associated statistics

\dontrun{
asreml.options(keep.order = TRUE) #required for asreml-R4 only
current.asr <- asreml(fixed = pH ~ Benches + (Sources * (Type + Species)), 
                      random = ~ Benches:MainPlots,
                      keep.order=TRUE, data= WaterRunoff.dat)
current.asrt <- as.asrtests(current.asr, NULL, NULL)
TS.diffs <- predictPlus(classify = "Sources:Type", 
                        asreml.obj = current.asr, 
                        wald.tab = current.asrt$wald.tab, 
                        present = c("Sources", "Type", "Species"))
}

## Use lmeTest and emmmeans to get predictions and associated statistics

if (requireNamespace("lmerTest", quietly = TRUE) & 
    requireNamespace("emmeans", quietly = TRUE))
{
  m1.lmer <- lmerTest::lmer(pH ~ Benches + (Sources * (Type + Species)) + 
                              (1|Benches:MainPlots),
                            data=na.omit(WaterRunoff.dat))
  TS.emm <- emmeans::emmeans(m1.lmer, specs = ~ Sources:Type)
  TS.preds <- summary(TS.emm)
  den.df <- min(TS.preds$df, na.rm = TRUE)
  ## Modify TS.preds to be compatible with a predictions.frame
  TS.preds <- as.predictions.frame(TS.preds, predictions = "emmean", 
                                   se = "SE", interval.type = "CI", 
                                   interval.names = c("lower.CL", "upper.CL"))
   
  ## Form an all.diffs object and check its validity
  TS.vcov <- vcov(TS.emm)
  TS.diffs <- allDifferences(predictions = TS.preds, classify = "Sources:Type", 
                             vcov = TS.vcov, tdf = den.df)
  validAlldiffs(TS.diffs)
}  

## Plot p-values for predictions obtained using asreml or lmerTest
if (exists("TS.diffs"))
{
  ##Pick the LSD values for predictions obtained using asreml or lmerTest  
  LSDstat <- pickLSDstatistics(TS.diffs)
  TS.diffs <- redoErrorIntervals(TS.diffs, LSDstatistic = LSDstat)
  TS.diffs$LSD
  LSDstat <- pickLSDstatistics(TS.diffs, LSDtype = "factor.combinations", 
                         LSDby = "Sources")
  TS.diffs <- redoErrorIntervals(TS.diffs, LSDtype = "factor.combinations", 
                                 LSDby = "Sources", LSDstatistic = LSDstat)
  TS.diffs$LSD
}
}
\keyword{asreml}