% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asm.R
\name{predict.asm}
\alias{predict.asm}
\title{Predict new responses using an \code{asm} regression model.}
\usage{
\method{predict}{asm}(object, newdata = NULL, interval = "none", level = 0.95, ...)
}
\arguments{
\item{object}{asm object}

\item{newdata}{new data frame}

\item{interval}{type of interval calculation,
either "none", "confidence" or "prediction". Default is "none".}

\item{level}{confidence level}

\item{...}{additional arguments to ensure compatibility with the generic function predict()}
}
\value{
matrix of predicted values
* if interval = "none", the matrix has one column of predicted values
* if interval = "confidence" or "prediction", the matrix has three columns: predicted value, lower bound, and upper bound
}
\description{
Outputs predictions on new test data based on a fitted \code{asm} regression model. Also returns a confidence interval around
the conditional mean (if interval = "confidence") or predicted response (if interval = "prediction").
}
\examples{
model = asm(mpg ~ cyl + hp + disp, data=mtcars)

}
