% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{asciicast-package}
\alias{asciicast-package}
\title{asciicast parameters}
\description{
You can set asciicast parameters in the header of the recorded R script.
The header is in DCF format (see \code{\link[=read.dcf]{read.dcf()}}), but all lines are prefixed
with \verb{#'} comments.
}
\details{
The DCF header may specify arbitrary parameters. We list here the
parameters that are interpreted by the asciicast functions.

Recording parameters:
\itemize{
\item \code{allow_errors}: Whether to cast errors properly. If this is set to
\code{TRUE}, then asciicast overwrites the \code{"error"} option. Only change
this if you know what you are doing.
\item \code{cols}: Width of the terminal, in number of characters.
\item \code{empty_wait}: How long to wait for empty lines in the script file,
in seconds.
\item \code{end_wait}: Delay at the very end, in seconds.
\item \code{env}: Environment variables to include in the case JSON file.
Defaults to \code{list(TERM = "xterm-256color", SHELL = "/bin/zsh")}.
\item \code{idle_time_limit}: Time limit for the cast not printing anything,
in seconds. By default there is no limit.
\item \code{record_env}: Environment variables to set for the R subprocess.
\item \code{rows}: Height of the terminal, in number of characters.
\item \code{start_wait}: Delay at the beginning, in seconds.
\item \code{timeout}: Idle timeout, in seconds If the R subprocess running
the recording does not answer within this limit, it is killed and the
recording stops. Update this for slow running code, that produces no
output as it runs.
\item \code{timestamp}: Time stamp of the recording, defaults to \code{Sys.time()},
this is included in the cast JSON file.
\item \code{title}: Title of the cast, this is included in the cast JSON file.
\item \code{typing_speed}: Average typing speed, per keypress, in seconds.
}

Asciinema player parameters:
\itemize{
\item \code{author}: Author, displayed in the titlebar in fullscreen mode.
\item \code{author_img_url}: URL of the author's image, displayed in the
titlebar in fullscreen mode.
\item \code{author_url}: URL of the author's homepage/profile. Author name
(author above) is linked to this URL.
\item \code{autoplay}: Whether to start playing the cast automatically.
\item \code{cols}: Width of the terminal, in number of characters.
\item \code{font_size}: Size of terminal font. Possible values: small, medium,
big, any css \code{font-size} value (e.g. 15px).
\item \code{idle_time_limit}: Time limit for the cast not printing anything,
in seconds. By default there is no limit.
\item \code{loop}: Whether to loop the playback.
\item \code{poster_frame}: Which frame to use (in seconds) as the preview picture.
\item \code{poster_text}: Text to use as the preview picture. Defaults to the
title.
\item \code{rows}: Height of the terminal, in number of characters.
\item \code{speed}: Whether to play slower or faster. 1 is normal speed.
\item \code{start_at}: Where to start the playback from, in seconds.
\item \code{theme}: Theme to use, currently it has to be a string, one of
\code{"asciinema"}, \code{"tango"}, \code{"solarized-dark"}, \code{"solarized-light"},
\code{"monokai"}. The first one is the default.
\item \code{title}: Title of the cast.
}

Parameters for SVG files:
\itemize{
\item \code{at}: Timestamp of single frame to render, in seconds.
\item \code{cols}: Width of the terminal, in number of characters.
\item \code{cursor}: Enable cursor rendering.
\item \code{end_at}: Upper range of timeline to render in seconds.
\item \code{padding}: Distance between text and image bounds.
\item \code{padding_x}: Distance between text and image bounds on x axis.
\item \code{padding_y}: Distance between text and image bounds on y axis.
\item \code{rows}: Height of the terminal, in number of characters.
\item \code{start_at}: Where to start the playback from, in seconds.
\item \code{window}: Render with window decorations.
\item \code{theme}: Theme to use, currently it has to be a string referring to
a build-in theme, or a named list of theme properties,
see \code{\link[=default_theme]{default_theme()}}.
The built-in themes are \code{"asciinema"}, \code{"tango"}, \code{"solarized-dark"},
\code{"solarized-light"}, \code{"seti"}, \code{"monokai"}, \code{"github-light"},
\code{"pkgdown"}.
}
}
\seealso{
Other asciicast functions: 
\code{\link{asciicast_start_process}()},
\code{\link{read_cast}()},
\code{\link{record}()},
\code{\link{write_json}()}
}
\concept{asciicast functions}
