% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlwidget.R
\name{asciinema_player}
\alias{asciinema_player}
\title{asciinema player HTML widget}
\usage{
asciinema_player(
  cast,
  start_at = 0,
  rows = NULL,
  cols = NULL,
  autoplay = NULL,
  loop = NULL,
  speed = NULL,
  title = NULL,
  author = NULL,
  author_url = NULL,
  author_img_url = NULL,
  poster_text = NULL,
  poster_frame = NULL,
  font_size = NULL,
  theme = NULL,
  idle_time_limit = NULL,
  html_height = NULL,
  html_width = NULL,
  element_id = NULL
)
}
\arguments{
\item{cast}{\code{asciicast} object.}

\item{start_at}{Where to start the playback from, in seconds.}

\item{rows}{Number of rows, defaults to the number of rows in the
recording, or 24 if not specified in the cast.}

\item{cols}{Number of columns, defaults to the number columns in the
recording, or 80 if not specified in the cast.}

\item{autoplay}{Whether to start playing the cast automatically.}

\item{loop}{Whether to loop the playback.}

\item{speed}{Whether to play slower or faster. 1 is normal speed.}

\item{title}{If specified, it overrides the title in the recording.}

\item{author}{Author, displayed in the titlebar in fullscreen mode.}

\item{author_url}{URL of the author's homepage/profile. Author name
(author above) is linked to this URL.}

\item{author_img_url}{URL of the author's image, displayed in the
titlebar in fullscreen mode.}

\item{poster_text}{if not \code{NULL}, used as the text of the poster
(preview).}

\item{poster_frame}{Which frame to use for the preview. A number means
seconds. Defaults to the last frame. This is only used if \code{poster_text}
is \code{NULL}.}

\item{font_size}{Size of terminal font. Possible values: small, medium,
big, any css \code{font-size} value (e.g. 15px).}

\item{theme}{Theme.}

\item{idle_time_limit}{Time limit for the cast not printing anything,
in seconds. By default there is no limit.}

\item{html_height}{HTML height of the widget.}

\item{html_width}{HTML width of the widget.}

\item{element_id}{HTML id of the widget's element. If \code{NULL}, then the
id is generated randomly.}
}
\description{
You can use this widget in Rmd files or Shiny applications, the
same way as \href{http://www.htmlwidgets.org/}{other HTML widgets}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cast <- read_cast(system.file("examples", "hello.cast", package = "asciicast"))
asciinema_player(cast)
\dontshow{\}) # examplesIf}
}
