context("parse-value-labels")
crosswalk_values       <- parse_value_labels(crosswalk_parsed)
parole_values          <- parse_value_labels(parole_parsed)
ucr1985_values         <- parse_value_labels(ucr1985_parsed)
ucr1986_values         <- parse_value_labels(ucr1986_parsed)
ucr2000_values         <- parse_value_labels(ucr2000_parsed)
#ucr2006_values         <- parse_value_labels(ucr2006_parsed)
sac_values             <- parse_value_labels(sac_parsed)
sex_offender_values    <- parse_value_labels(sex_offender_parsed)
ucr1960_values         <- parse_value_labels(ucr1960_parsed)
weimar_values          <- parse_value_labels(weimar_parsed)
acs_values             <- parse_value_labels(acs_parsed)
nibrs_values           <- parse_value_labels(nibrs_parsed)
prisoners_values       <- parse_value_labels(prisoners_parsed)
SHR1987_values         <- parse_value_labels(SHR1987_parsed)
SHR1988_values         <- parse_value_labels(SHR1988_parsed)
SHR1981_values         <- parse_value_labels(SHR1981_parsed)
ca_vital_values        <- parse_value_labels(ca_vital_parsed)
leoka1980_values       <- parse_value_labels(leoka1980_parsed)
property_stolen_values <- parse_value_labels(property_stolen_parsed)

test_that("Number of value label columns are correct", {

  expect_equal(length(crosswalk_values), 19)
  expect_equal(length(parole_values), 51)
#  expect_equal(length(ucr1985_values), )
#  expect_equal(length(ucr1986_values), )
#  expect_equal(length(ucr2000_values), )
  #  expect_equal(length(ucr2006_values), )
#  expect_equal(length(sac_values), )
  expect_equal(length(sex_offender_values), 32)
#  expect_equal(length(ucr1960_values), )
  expect_equal(length(weimar_values), 0)
  expect_equal(length(acs_values), 4)
  expect_equal(length(nibrs_values), 9)
#  expect_equal(length(prisoners_values), )
  expect_equal(length(ca_vital_values), 36)
  expect_equal(length(property_stolen_values), 15)
#  expect_equal(length(ASR), 36)

})


test_that("parse value labels is silent", {

  expect_silent(parse_value_labels(crosswalk_parsed))
  expect_silent(parse_value_labels(parole_parsed))
  expect_silent(parse_value_labels(ucr1985_parsed))
  expect_silent(parse_value_labels(ucr1986_parsed))
  expect_silent(parse_value_labels(ucr2000_parsed))
#  expect_silent(parse_value_labels(ucr2006_parsed))
  expect_silent(parse_value_labels(sac_parsed))
  expect_silent(parse_value_labels(sex_offender_parsed))
  expect_silent(parse_value_labels(ucr1960_parsed))
  expect_silent(parse_value_labels(weimar_parsed))
  expect_silent(parse_value_labels(acs_parsed))
  expect_silent(parse_value_labels(nibrs_parsed))
  expect_silent(parse_value_labels(prisoners_parsed))
  expect_silent(parse_value_labels(SHR1987_parsed))
  expect_silent(parse_value_labels(SHR1987_parsed))
  expect_silent(parse_value_labels(SHR1981_parsed))
  expect_silent(parse_value_labels(ca_vital_parsed))
  expect_silent(parse_value_labels(property_stolen_values))
#  expect_silent(parse_value_labels(ASR))

})


test_that("SHR1981 - parsed value labels are accurate", {
  expect_equal(SHR1981_values$V1, c("ICPSR Study Number" = "9028"))
  expect_equal(SHR1981_values$V2, c("Second edition, February 1994" = "2"))
  expect_equal(SHR1981_values$V3, c("Part 7: SHR 1981" = "7"))
  expect_equal(SHR1981_values$V5, c("SHR master file" = "6"))
  expect_equal(SHR1981_values$V6, c("Alabama" = "01",
                                           "Arizona" = "02",
                                           "Arkansas" = "03",
                                           "California" = "04",
                                           "Colorado" = "05",
                                           "Connecticut" = "06",
                                           "Delaware" = "07",
                                           "Washington, D.C" = "08",
                                           "Florida" = "09",
                                           "Georgia" = "10",
                                           "Idaho" = "11",
                                           "Illinois" = "12",
                                           "Indiana" = "13",
                                           "Iowa" = "14",
                                           "Kansas" = "15",
                                           "Kentucky" = "16",
                                           "Louisiana" = "17",
                                           "Maine" = "18",
                                           "Maryland" = "19",
                                           "Massachusetts" = "20",
                                           "Michigan" = "21",
                                           "Minnesota" = "22",
                                           "Mississippi" = "23",
                                           "Missouri" = "24",
                                           "Montana" = "25",
                                           "Nebraska" = "26",
                                           "Nevada" = "27",
                                           "New Hampshire" = "28",
                                           "New Jersey" = "29",
                                           "New Mexico" = "30",
                                           "New York" = "31",
                                           "North Carolina" = "32",
                                           "North Dakota" = "33",
                                           "Ohio" = "34",
                                           "Oklahoma" = "35",
                                           "Oregon" = "36",
                                           "Pennsylvania" = "37",
                                           "Rhode Island" = "38",
                                           "South Carolina" = "39",
                                           "South Dakota" = "40",
                                           "Tennessee" = "41",
                                           "Texas" = "42",
                                           "Utah" = "43",
                                           "Vermont" = "44",
                                           "Virginia" = "45",
                                           "Washington" = "46",
                                           "West Virginia" = "47",
                                           "Wisconsin" = "48",
                                           "Wyoming" = "49",
                                           "Alaska" = "50",
                                           "Hawaii" = "51",
                                           "Canal Zone" = "52",
                                           "Puerto Rico" = "53",
                                           "American Samoa" = "54",
                                           "Guam" = "55",
                                           "Virgin Islands" = "62"))
  expect_equal(SHR1981_values$V8, c("Possessions" = "0",
                                           "All cities 1,000,000 or over" = "11",
                                           "Cities 500,000 thru 999,999" = "12",
                                           "Cities 250,000 thru 499,999" = "13",
                                           "Cities 100,000 thru 249,999" = "20",
                                           "Cities 50,000 thru 99,999" = "30",
                                           "Cities 25,000 thru 49,999" = "40",
                                           "Cities 10,000 thru 24,999" = "50",
                                           "Cities 2,500 thru 9,999" = "60",
                                           "Cities under 2,500" = "70",
                                           "Non-MSA counties 100,000 or over" = "81",
                                           "Non-MSA counties 25,000 thru 99,999" = "82",
                                           "Non-MSA counties 10,000 thru 24,999" = "83",
                                           "Non-MSA counties under 10,000" = "84",
                                           "Non-MSA State Police" = "85",
                                           "MSA counties 100,000 or over" = "91",
                                           "MSA counties 25,000 thru 99,999" = "92",
                                           "MSA counties 10,000 thru 24,999" = "93",
                                           "MSA counties under 10,000" = "94",
                                           "MSA State Police" = "95"))
  expect_equal(SHR1981_values$V9, c("Possessions" = "0",
                                           "New England States" = "1",
                                           "Middle Atlantic States" = "2",
                                           "East North Central States" = "3",
                                           "West North Central States" = "4",
                                           "South Atlantic States" = "5",
                                           "East South Central States" = "6",
                                           "West South Central States" = "7",
                                           "Mountain States" = "8",
                                           "Pacific States" = "9"))
  expect_equal(SHR1981_values$V10, c("1981" = "81"))
  expect_equal(SHR1981_values$V11, c("Unknown or not reported" = "0"))
  expect_equal(SHR1981_values$V12, c("Inapplicable" = "0"))
  expect_equal(SHR1981_values$V13, c("Inapplicable" = "0"))
  expect_equal(SHR1981_values$V14, c("Non-suburban" = "0",
                                            "Suburban" = "1"))
  expect_equal(SHR1981_values$V17, c("January" = "1",
                                            "February" = "2",
                                            "March" = "3",
                                            "April" = "4",
                                            "May" = "5",
                                            "June" = "6",
                                            "July" = "7",
                                            "August" = "8",
                                            "September" = "9",
                                            "October" = "10",
                                            "November" = "11",
                                            "December" = "12"))
  expect_equal(SHR1981_values$V20, c("Murder and non-negligent manslaughter" = "1",
                                            "Manslaughter by negligence" = "2"))
  expect_equal(SHR1981_values$V22, c("Single victim/single offender" = "1",
                                            "Single victim/unknown offender(s)" = "2",
                                            "Single victim/multiple offenders" = "3",
                                            "Multiple victims/single offender" = "4",
                                            "Multiple victims/multiple offenders" = "5",
                                            "Multiple victims/unknown offender(s)" = "6"))
  expect_equal(SHR1981_values$V25, c("Birth to 6 days old" = "100",
                                            "7 days old to 364 days old" = "101",
                                            "1 year old" = "1",
                                            "99 years old or more" = "99",
                                            "Unknown" = "999",
                                            "Out of Universe" = "900"))
  expect_equal(SHR1981_values$V26, c("Male" = "1",
                                            "Female" = "2",
                                            "Unknown" = "9"))
  expect_equal(SHR1981_values$V27, c("White" = "1",
                                            "Black" = "2",
                                            "American Indian or Alaskan Native" = "3",
                                            "Asian or Pacific Islander" = "4",
                                            "Unknown" = "9"))
  expect_equal(SHR1981_values$V28, c("Hispanic origin" = "1",
                                            "Not of Hispanic origin" = "2",
                                            "Unknown" = "9"))
  expect_equal(SHR1981_values$V29, c("Birth to 6 days old" = "100",
                                            "7 days old to 364 days old" = "101",
                                            "1 year old" = "001",
                                            "99 years old or more" = "099",
                                            "Inap, only one victim" = "998",
                                            "Unknown" = "999"))
  expect_equal(SHR1981_values$V30, c("Male" = "1",
                                            "Female" = "2",
                                            "Inap, only one victim" = "8",
                                            "Unknown" = "9"))
  expect_equal(SHR1981_values$V31, c("White" = "1",
                                            "Black" = "2",
                                            "American Indian or Alaskan Native" = "3",
                                            "Asian or Pacific Islander" = "4",
                                            "Inap, only one victim" = "8",
                                            "Unknown" = "9"))
  expect_equal(SHR1981_values$V32, c("Hispanic origin" = "1",
                                            "Not of Hispanic origin" = "2",
                                            "Inap, only one victim" = "8",
                                            "Unknown" = "9"))
  expect_equal(SHR1981_values$V33, c("Birth to 6 days old" = "100",
                                            "7 days old to 364 days old" = "101",
                                            "1 year old" = "001",
                                            "99 years old or more" = "099",
                                            "Inap, less than 3 victims" = "998",
                                            "Unknown" = "999"))
  expect_equal(SHR1981_values$V34, c("Male" = "1",
                                              "Female" = "2",
                                              "Inap, less than 3 victims" = "8",
                                              "Unknown" = "9"))
  expect_equal(SHR1981_values$V69, c("Age unknown" = "999"))
  expect_equal(SHR1981_values$V73, c("Firearm, type not stated" = "11",
                                       "Handgun - pistol, revolver, etc" = "12",
                                       "Rifle" = "13",
                                       "Shotgun" = "14",
                                       "Other gun" = "15",
                                       "Knife or cutting instrument" = "20",
                                       "Blunt object" = "30",
                                       "Personal weapons" = "40",
                                       "Poison - does not include gas" = "50",
                                       "Pushed or thrown out window" = "55",
                                       "Explosives" = "60",
                                       "Fire" = "65",
                                       "Narcotics or drugs" = "70",
                                       "Drowning" = "75",
                                       "Strangulation - hanging" = "80",
                                       "Asphyxiation - includes death by gas" = "85",
                                       "Other - type of weapon not designated" = "90"))
  expect_equal(SHR1981_values$V74, c("Husband" = "01",
                                       "Wife" = "02",
                                       "Common-law husband" = "03",
                                       "Common-law wife" = "04",
                                       "Mother" = "05",
                                       "Father" = "06",
                                       "Son" = "07",
                                       "Daughter" = "08",
                                       "Brother" = "09",
                                       "Sister" = "10",
                                       "In-law" = "11",
                                       "Stepfather" = "12",
                                       "Stepmother" = "13",
                                       "Stepson" = "14",
                                       "Stepdaughter" = "15",
                                       "Other family" = "16",
                                       "Neighbor" = "17",
                                       "Acquaintance" = "18",
                                       "Boyfriend" = "19",
                                       "Girlfriend" = "20",
                                       "Ex-husband" = "21",
                                       "Ex-wife" = "22",
                                       "Employee" = "23",
                                       "Employer" = "24",
                                       "Friend" = "25",
                                       "Homosexual relationship" = "26",
                                       "Other - known to victim" = "27",
                                       "Stranger" = "28",
                                       "Relationship not determined" = "99"))
  expect_equal(SHR1981_values$V75, c("Rape" = "02",
                                       "Robbery" = "03",
                                       "Burglary" = "05",
                                       "Larceny" = "06",
                                       "Motor vehicle theft" = "07",
                                       "Arson" = "09",
                                       "Prostitution and commercialized vice" = "10",
                                       "Other sex offense" = "17",
                                       "Abortion" = "32",
                                       "Narcotic drug laws" = "18",
                                       "Gambling" = "19",
                                       "Other - not specified" = "26",
                                       "Lover s triangle" = "40",
                                       "Child killed by babysitter" = "41",
                                       "Brawl due to influence of alcohol" = "42",
                                       "Brawl due to influence of narcotics" = "43",
                                       "Argument over money or property" = "44",
                                       "Other arguments" = "45",
                                       "Gangland killings" = "46",
                                       "Juvenile gang killings" = "47",
                                       "Institutional killings" = "48",
                                       "Sniper attack" = "49",
                                       "Other" = "60",
                                       "All suspected felony type" = "70",
                                       "Felon killed by private citizen" = "80",
                                       "Felon killed by police" = "81",
                                       "Circumstances undetermined" = "99"))
  expect_equal(SHR1981_values$V76, c("Felon attacked police officer" = "1",
                                       "Felon attacked fellow police officer" = "2",
                                       "Felon attacked a civilian" = "3",
                                       "Felon attempted flight from a crime" = "4",
                                       "Felon killed in commission of a crime" = "5",
                                       "Felon resisted arrest" = "6",
                                       "Not enough information to determine" = "7",
                                       "Inap, not a justifiable homicide" = "9"))
  expect_equal(SHR1981_values$V77, c("Inap, only one offender" = "998",
                                       "Unknown" = "999"))
  })


test_that("ACS - parsed value labels are accurate", {
  expect_equal(acs_values$STATEFIP, c("Alabama" = "01",
                                      "Alaska" = "02",
                                      "Arizona" = "04",
                                      "Arkansas" = "05",
                                      "California" = "06",
                                      "Colorado" = "08",
                                      "Connecticut" = "09",
                                      "Delaware" = "10",
                                      "District of Columbia" = "11",
                                      "Florida" = "12",
                                      "Georgia" = "13",
                                      "Hawaii" = "15",
                                      "Idaho" = "16",
                                      "Illinois" = "17",
                                      "Indiana" = "18",
                                      "Iowa" = "19",
                                      "Kansas" = "20",
                                      "Kentucky" = "21",
                                      "Louisiana" = "22",
                                      "Maine" = "23",
                                      "Maryland" = "24",
                                      "Massachusetts" = "25",
                                      "Michigan" = "26",
                                      "Minnesota" = "27",
                                      "Mississippi" = "28",
                                      "Missouri" = "29",
                                      "Montana" = "30",
                                      "Nebraska" = "31",
                                      "Nevada" = "32",
                                      "New Hampshire" = "33",
                                      "New Jersey" = "34",
                                      "New Mexico" = "35",
                                      "New York" = "36",
                                      "North Carolina" = "37",
                                      "North Dakota" = "38",
                                      "Ohio" = "39",
                                      "Oklahoma" = "40",
                                      "Oregon" = "41",
                                      "Pennsylvania" = "42",
                                      "Rhode Island" = "44",
                                      "South Carolina" = "45",
                                      "South Dakota" = "46",
                                      "Tennessee" = "47",
                                      "Texas" = "48",
                                      "Utah" = "49",
                                      "Vermont" = "50",
                                      "Virginia" = "51",
                                      "Washington" = "53",
                                      "West Virginia" = "54",
                                      "Wisconsin" = "55",
                                      "Wyoming" = "56",
                                      "Maine-New Hampshire-Vermont" = "61",
                                      "Massachusetts-Rhode Island" = "62",
                                      "Minnesota-Iowa-Missouri-Kansas-Nebraska-S.Dakota-N.Dakota" = "63",
                                      "Maryland-Delaware" = "64",
                                      "Montana-Idaho-Wyoming" = "65",
                                      "Utah-Nevada" = "66",
                                      "Arizona-New Mexico" = "67",
                                      "Alaska-Hawaii" = "68",
                                      "Puerto Rico" = "72",
                                      "Military/Mil. Reservation" = "97",
                                      "State not identified" = "99"))
  expect_equal(acs_values$GQ, c("Vacant unit" = "0",
                                "Households under 1970 definition" = "1",
                                "Additional households under 1990 definition" = "2",
                                "Group quarters--Institutions" = "3",
                                "Other group quarters" = "4",
                                "Additional households under 2000 definition" = "5",
                                "Fragment" = "6"))
  expect_equal(acs_values$SEX, c("Male" = "1",
                                 "Female" = "2"))
  expect_equal(acs_values$AGE, c("Less than 1 year old" = "000",
                                 "1" = "001",
                                 "2" = "002",
                                 "3" = "003",
                                 "4" = "004",
                                 "5" = "005",
                                 "6" = "006",
                                 "7" = "007",
                                 "8" = "008",
                                 "9" = "009",
                                 "10" = "010",
                                 "11" = "011",
                                 "12" = "012",
                                 "13" = "013",
                                 "14" = "014",
                                 "15" = "015",
                                 "16" = "016",
                                 "17" = "017",
                                 "18" = "018",
                                 "19" = "019",
                                 "20" = "020",
                                 "21" = "021",
                                 "22" = "022",
                                 "23" = "023",
                                 "24" = "024",
                                 "25" = "025",
                                 "26" = "026",
                                 "27" = "027",
                                 "28" = "028",
                                 "29" = "029",
                                 "30" = "030",
                                 "31" = "031",
                                 "32" = "032",
                                 "33" = "033",
                                 "34" = "034",
                                 "35" = "035",
                                 "36" = "036",
                                 "37" = "037",
                                 "38" = "038",
                                 "39" = "039",
                                 "40" = "040",
                                 "41" = "041",
                                 "42" = "042",
                                 "43" = "043",
                                 "44" = "044",
                                 "45" = "045",
                                 "46" = "046",
                                 "47" = "047",
                                 "48" = "048",
                                 "49" = "049",
                                 "50" = "050",
                                 "51" = "051",
                                 "52" = "052",
                                 "53" = "053",
                                 "54" = "054",
                                 "55" = "055",
                                 "56" = "056",
                                 "57" = "057",
                                 "58" = "058",
                                 "59" = "059",
                                 "60" = "060",
                                 "61" = "061",
                                 "62" = "062",
                                 "63" = "063",
                                 "64" = "064",
                                 "65" = "065",
                                 "66" = "066",
                                 "67" = "067",
                                 "68" = "068",
                                 "69" = "069",
                                 "70" = "070",
                                 "71" = "071",
                                 "72" = "072",
                                 "73" = "073",
                                 "74" = "074",
                                 "75" = "075",
                                 "76" = "076",
                                 "77" = "077",
                                 "78" = "078",
                                 "79" = "079",
                                 "80" = "080",
                                 "81" = "081",
                                 "82" = "082",
                                 "83" = "083",
                                 "84" = "084",
                                 "85" = "085",
                                 "86" = "086",
                                 "87" = "087",
                                 "88" = "088",
                                 "89" = "089",
                                 "90 (90+ in 1980 and 1990)" = "090",
                                 "91" = "091",
                                 "92" = "092",
                                 "93" = "093",
                                 "94" = "094",
                                 "95" = "095",
                                 "96" = "096",
                                 "97" = "097",
                                 "98" = "098",
                                 "99" = "099",
                                 "100 (100+ in 1960-1970)" = "100",
                                 "101" = "101",
                                 "102" = "102",
                                 "103" = "103",
                                 "104" = "104",
                                 "105" = "105",
                                 "106" = "106",
                                 "107" = "107",
                                 "108" = "108",
                                 "109" = "109",
                                 "110" = "110",
                                 "111" = "111",
                                 "112 (112+ in the 1980 internal data)" = "112",
                                 "113" = "113",
                                 "114" = "114",
                                 "115 (115+ in the 1990 internal data)" = "115",
                                 "116" = "116",
                                 "117" = "117",
                                 "118" = "118",
                                 "119" = "119",
                                 "120" = "120",
                                 "121" = "121",
                                 "122" = "122",
                                 "123" = "123",
                                 "124" = "124",
                                 "125" = "125",
                                 "126" = "126",
                                 "129" = "129",
                                 "130" = "130",
                                 "135" = "135"))

})


test_that("crosswalk - parsed value labels are accurate", {
  expect_equal(crosswalk_values$SOURCE, c("Other" = "0",
                                          "UCR only" = "1",
                                          "DLEA only" = "2",
                                          "UCR and DLEA" = "3"))
  expect_equal(crosswalk_values$UORI, c("Unknown" = "M"))
  expect_equal(crosswalk_values$UCORI, c("ORI rpts thru other ORI" = "*"))
  expect_equal(crosswalk_values$UMULTICO, c("ORI in > 1 county" = "*"))
  expect_equal(crosswalk_values$UCOUNTY, c("Inap" = "0",
                                           "Unknown" = "999"))
  expect_equal(crosswalk_values$UMSA, c("Inap" = "0",
                                    "Unknown/ not an MSA" = "999"))
  expect_equal(crosswalk_values$UPOPGRP, c("Unknown" = "M",
                                           "Possessions" = "0",
                                           "All cities 250,000 or over" = "1",
                                           "Cities 1,000,000 or over" = "1A",
                                           "Cities from 500,000 thru 999,000" = "1B",
                                           "Cities from 250,000 thru 499,999" = "1C",
                                           "Cities from 100,000 thru 249,000" = "2",
                                           "Cities from 50,000 thru 99,999" = "3",
                                           "Cities from 25,000 thru 49,999" = "4",
                                           "Cities from 10,000 thru 24,999" = "5",
                                           "Cities from 2,500 thru 9,999" = "6",
                                           "Cities under 2,500" = "7",
                                           "Non-MSA counties" = "8",
                                           "Non-MSA counties 100,000 or over" = "8A",
                                           "Non-MSA counties from 25,000 thru 99,999" = "8B",
                                           "Non-MSA counties from 10,000 thru 24,999" = "8C",
                                           "Non-MSA counties under 10,000" = "8D",
                                           "Non-MSA State Police" = "8E",
                                           "MSA counties" = "9",
                                           "MSA counties 100,000 or over" = "9A",
                                           "MSA counties from 25,000 thru 99,999" = "9B",
                                           "MSA counties from 10,000 thru 24,999" = "9C",
                                           "MSA counties under 10,000" = "9D",
                                           "MSA State Police" = "9E"))
  expect_equal(crosswalk_values$UPOPCOV, c("Unknown" = "9999999"))
  expect_equal(crosswalk_values$UADD5, c("Unknown" = "99999"))
  expect_equal(crosswalk_values$CGOVIDNU, c("Unknown" = "999999999"))
  expect_equal(crosswalk_values$CGOVTYPE, c("State" = "0",
                                            "County" = "1",
                                            "Municipal" = "2",
                                            "Township" = "3",
                                            "Special district" = "4",
                                            "Independent school district" = "5",
                                            "Federal agency" = "6",
                                            "Tribal" = "7",
                                            "Railroad police" = "8",
                                            "College/university" = "9",
                                            "Unknown" = "99"))
  expect_equal(crosswalk_values$CPOP94, c("Unknown" = "99999999"))
  expect_equal(crosswalk_values$FSTATE, c("Alabama" = "1",
                                          "Alaska" = "2",
                                          "Arizona" = "4",
                                          "Arkansas" = "5",
                                          "California" = "6",
                                          "Colorado" = "8",
                                          "Connecticut" = "9",
                                          "Delaware" = "10",
                                          "District of Columbia" = "11",
                                          "Florida" = "12",
                                          "Georgia" = "13",
                                          "Hawaii" = "15",
                                          "Idaho" = "16",
                                          "Illinois" = "17",
                                          "Indiana" = "18",
                                          "Iowa" = "19",
                                          "Kansas" = "20",
                                          "Kentucky" = "21",
                                          "Louisiana" = "22",
                                          "Maine" = "23",
                                          "Maryland" = "24",
                                          "Massachusetts" = "25",
                                          "Michigan" = "26",
                                          "Minnesota" = "27",
                                          "Mississippi" = "28",
                                          "Missouri" = "29",
                                          "Montana" = "30",
                                          "Nebraska" = "31",
                                          "Nevada" = "32",
                                          "New Hampshire" = "33",
                                          "New Jersey" = "34",
                                          "New Mexico" = "35",
                                          "New York" = "36",
                                          "North Carolina" = "37",
                                          "North Dakota" = "38",
                                          "Ohio" = "39",
                                          "Oklahoma" = "40",
                                          "Oregon" = "41",
                                          "Pennsylvania" = "42",
                                          "Rhode Island" = "44",
                                          "South Carolina" = "45",
                                          "South Dakota" = "46",
                                          "Tennessee" = "47",
                                          "Texas" = "48",
                                          "Utah" = "49",
                                          "Vermont" = "50",
                                          "Virginia" = "51",
                                          "Washington" = "53",
                                          "West Virginia" = "54",
                                          "Wisconsin" = "55",
                                          "Wyoming" = "56",
                                          "Guam" = "66",
                                          "Puerto Rico" = "72",
                                          "Unknown" = "99"))
  expect_equal(crosswalk_values$FCOUNTY, c("Unknown" = "999"))
  expect_equal(crosswalk_values$FPLACE, c("Tribes" = "97000",
                                          "State HQ" = "98000",
                                          "Unknown" = "999999"))
  expect_equal(crosswalk_values$FMSA, c("Unknown/ no MSA" = "9999"))
  expect_equal(crosswalk_values$FCMSA, c("Unknown" = "999"))


})


test_that("UCR1960 - parsed value labels are accurate", {
  expect_equal(ucr1960_values$V1, c("Offenses known" = "1"))
  expect_equal(ucr1960_values$V2, c("Alabama" = "1",
                                    "Arizona" = "2",
                                    "Arkansas" = "3",
                                    "California" = "4",
                                    "Colorado" = "5",
                                    "Connecticut" = "6",
                                    "Delaware" = "7",
                                    "District of Columbia" = "8",
                                    "Florida" = "9",
                                    "Georgia" = "10",
                                    "Idaho" = "11",
                                    "Illinois" = "12",
                                    "Indiana" = "13",
                                    "Iowa" = "14",
                                    "Kansas" = "15",
                                    "Kentucky" = "16",
                                    "Louisiana" = "17",
                                    "Maine" = "18",
                                    "Maryland" = "19",
                                    "Massachusetts" = "20",
                                    "Michigan" = "21",
                                    "Minnesota" = "22",
                                    "Mississippi" = "23",
                                    "Missouri" = "24",
                                    "Montana" = "25",
                                    "Nebraska" = "26",
                                    "Nevada" = "27",
                                    "New Hampshire" = "28",
                                    "New Jersey" = "29",
                                    "New Mexico" = "30",
                                    "New York" = "31",
                                    "North Carolina" = "32",
                                    "North Dakota" = "33",
                                    "Ohio" = "34",
                                    "Oklahoma" = "35",
                                    "Oregon" = "36",
                                    "Pennsylvania" = "37",
                                    "Rhode Island" = "38",
                                    "South Carolina" = "39",
                                    "South Dakota" = "40",
                                    "Tennessee" = "41",
                                    "Texas" = "42",
                                    "Utah" = "43",
                                    "Vermont" = "44",
                                    "Virginia" = "45",
                                    "Washington" = "46",
                                    "West Virginia" = "47",
                                    "Wisconsin" = "48",
                                    "Wyoming" = "49",
                                    "Alaska" = "50",
                                    "Hawaii" = "51",
                                    "Canal Zone" = "52",
                                    "Puerto Rico" = "53",
                                    "American Samoa" = "54",
                                    "Guam" = "55",
                                    "Virgin Islands" = "62"))
  expect_equal(ucr1960_values$V4, c("Possessions" = "0",
                                    "ALL cit 250,000 +" = "1",
                                    "Cit 1,000,000 +" = "1A",
                                    "Cit 500,000-999,999" = "1B",
                                    "Cit 250,000-499,999" = "1C",
                                    "Cit 100,000-249,999" = "2",
                                    "Cit 50,000-99,999" = "3",
                                    "Cit 25,000-49,999" = "4",
                                    "Cit 10,000-24,999" = "5",
                                    "Cit 2,500-9,999" = "6",
                                    "Cit < 2,500" = "7",
                                    "Non-MSA co." = "8",
                                    "Non-MSA co. 100,000 +" = "8A",
                                    "Non-MSA co. 25,000-99,999" = "8B",
                                    "Non-MSA co. 10,000-24,999" = "8C",
                                    "Non-MSA co. < 10,000" = "8D",
                                    "Non-MSA St Police" = "8E",
                                    "MSA counties" = "9",
                                    "MSA co. 100,000 +" = "9A",
                                    "MSA co. 25,000-99,999" = "9B",
                                    "MSA co. 10,000-24,999" = "9C",
                                    "MSA co. < 10,000" = "9D",
                                    "MSA St Police" = "9E"))
  expect_equal(ucr1960_values$V5, c("Possessions" = "0",
                                    "New Eng1and States" = "1",
                                    "Middle Atlantic States" = "2",
                                    "East North Central States" = "3",
                                    "West North Central States" = "4",
                                    "South Atlantic States" = "5",
                                    "East South Central States" = "6",
                                    "West South Central States" = "7",
                                    "Mountain States" = "8",
                                    "Pacific States" = "9"))
  expect_equal(ucr1960_values$V8, c("No, not core city of MSA" = "N",
                                    "Yes, core city of MSA" = "Y"))
  expect_equal(ucr1960_values$V12, c("No months reported" = "0",
                                  "Jan last reported" = "1",
                                  "Feb last reported" = "2",
                                  "March last reported" = "3",
                                  "April last reported" = "4",
                                  "May last reported" = "5",
                                  "June last reported" = "6",
                                  "July last reported" = "7",
                                  "August last reported" = "8",
                                  "Sep last reported" = "9",
                                  "Oct last reported" = "10",
                                  "Nov last reported" = "11",
                                  "Dec last reported" = "12"))
  expect_equal(ucr1960_values$V13, c("US Park & State Police" = "0",
                                  "All other agencies" = "1"))
  expect_equal(ucr1960_values$V23, c("No, do not send a follow-up" = "N",
                                  "Yes, send a follow-up" = "Y"))
  expect_equal(ucr1960_values$V24, c("Not special mail group agency" = "0",
                                     "Return sent to another agency" = "1",
                                     "Small city sent a large city form" = "2",
                                     "Agency-non-contributor, not sent form" = "7",
                                     "Agency-contributor, not on mail list" = "9"))
  expect_equal(ucr1960_values$V25, c("Not a special mailing address" = "N",
                                     "Special mailing address" = "Y"))
  expect_equal(ucr1960_values$V33, c("Jan not w oth month" = "0",
                                     "Reported with Jan" = "1",
                                     "Reported with Feb" = "2",
                                     "Reported with Mar" = "3",
                                     "Reported with Apr" = "4",
                                     "Reported with May" = "5",
                                     "Reported with Jun" = "6",
                                     "Reported with Jul" = "7",
                                     "Reported with Aug" = "8",
                                     "Reported with Sep" = "9",
                                     "Reported with Oct" = "10",
                                     "Reported with Nov" = "11",
                                     "Reported with Dec" = "12"))
  expect_equal(ucr1960_values$V34, c("Not updated" = "0"))
  expect_equal(ucr1960_values$V35, c("Not updated" = "0",
                                     "Adjustment" = "2",
                                     "Not available" = "4",
                                     "Normal return" = "5"))
  expect_equal(ucr1960_values$V36, c("Not updated" = "0",
                                     "Adjustment" = "2",
                                     "Not available" = "4",
                                     "Normal return" = "5"))
  expect_equal(ucr1960_values$V160, c("No return received" = " ",
                                      "Missing" = "0",
                                      "Breakdown offenses" = "P",
                                      "Totals only" = "T"))
  expect_equal(ucr1960_values$V270, c("Not updated" = "0"))
  expect_equal(ucr1960_values$V506, c("Not updated" = "0"))
  expect_equal(ucr1960_values$V509, c("Not updated" = "0",
                                      "Adjustment" = "2",
                                      "Not available" = "4",
                                      "Normal return" = "5"))
  expect_equal(ucr1960_values$V512, c("No return received" = " ",
                                  "Missing" = "0",
                                  "Breakdown offenses" = "P",
                                  "Totals only" = "T"))
  expect_equal(ucr1960_values$V1341, c("No return received" = " ",
                                      "Missing" = "0",
                                      "Breakdown offenses" = "P",
                                      "Totals only" = "T"))

})


test_that("nibrs - parsed value labels are accurate", {
  expect_equal(nibrs_values$B1001, c("Batch header 1" = "B1"))
  expect_equal(nibrs_values$B1002, c("AK" = "50",
                                     "AL" = "01",
                                     "AR" = "03",
                                     "AS" = "54",
                                     "AZ" = "02",
                                     "CA" = "04",
                                     "CO" = "05",
                                     "CT" = "06",
                                     "CZ" = "52",
                                     "DC" = "08",
                                     "DE" = "07",
                                     "FL" = "09",
                                     "GA" = "10",
                                     "GM" = "55",
                                     "HI" = "51",
                                     "IA" = "14",
                                     "ID" = "11",
                                     "IL" = "12",
                                     "IN" = "13",
                                     "KS" = "15",
                                     "KY" = "16",
                                     "LA" = "17",
                                     "MA" = "20",
                                     "MD" = "19",
                                     "ME" = "18",
                                     "MI" = "21",
                                     "MN" = "22",
                                     "MO" = "24",
                                     "MS" = "23",
                                     "MT" = "25",
                                     "NB" = "26",
                                     "NC" = "32",
                                     "ND" = "33",
                                     "NH" = "28",
                                     "NJ" = "29",
                                     "NM" = "30",
                                     "NV" = "27",
                                     "NY" = "31",
                                     "OH" = "34",
                                     "OK" = "35",
                                     "OR" = "36",
                                     "PA" = "37",
                                     "PR" = "53",
                                     "RI" = "38",
                                     "SC" = "39",
                                     "SD" = "40",
                                     "TN" = "41",
                                     "TX" = "42",
                                     "UT" = "43",
                                     "VI" = "62",
                                     "VA" = "45",
                                     "VT" = "44",
                                     "WA" = "46",
                                     "WI" = "48",
                                     "WV" = "47",
                                     "WY" = "49"))
  expect_equal(nibrs_values$B1009, c("Possessions" = "0",
                                     "Cities 250,000+" = "1",
                                     "Cities 1,000,000+" = "1A",
                                     "Cities 500,000-999,999" = "1B",
                                     "Cities 250,000-499,999" = "1C",
                                     "Cities 100,000-249,999" = "2",
                                     "Cities 50,000-99,999" = "3",
                                     "Cities 25,000-49,999" = "4",
                                     "Cities 10,000-24,999" = "5",
                                     "Cities 2,500-9,999" = "6",
                                     "Cites < 2,500" = "7",
                                     "Non-MSA Counties" = "8",
                                     "Non-MSA Counties 100,000+" = "8A",
                                     "Non-MSA Counties 25,000-99,999" = "8B",
                                     "Non-MSA Counties 10,000-24,999" = "8C",
                                     "Non-MSA Counties < 10,000" = "8D",
                                     "Non-MSA State Police" = "8E",
                                     "MSA Counties" = "9",
                                     "MSA Counties 100,000+" = "9A",
                                     "MSA Counties 25,000-99,999" = "9B",
                                     "MSA Counties 10,000-24,999" = "9C",
                                     "MSA Counties < 10,000" = "9D",
                                     "MSA State Police" = "9E"))
  expect_equal(nibrs_values$B1010, c("Possessions" = "0",
                                     "New England" = "1",
                                     "Middle Atlantic" = "2",
                                     "East North Central" = "3",
                                     "West North Central" = "4",
                                     "South Atlantic" = "5",
                                     "East South Central" = "6",
                                     "West South Central" = "7",
                                     "Mountain" = "8",
                                     "Pacific" = "9"))
  expect_equal(nibrs_values$B1011, c("North East" = "1",
                                     "North Central" = "2",
                                     "South" = "3",
                                     "West" = "4"))
  expect_equal(nibrs_values$B1012, c("Covered by another agency" = "0",
                                     "City" = "1",
                                     "County" = "2",
                                     "University or college" = "3",
                                     "State Police" = "4",
                                     "Special Agency" = "5"))
  expect_equal(nibrs_values$B1013, c("Yes" = "Y",
                                     "No" = "N"))
  expect_equal(nibrs_values$B1015, c("Blanked" = "9999"))
  expect_equal(nibrs_values$B1017, c("Inactive" = " ",
                                     "Active" = "A"))

})

test_that("Sex offenders - parsed value labels are accurate", {
  expect_equal(sex_offender_values$MEETING, c("1" = "1",
                                              "2" = "2",
                                              "3" = "3",
                                              "4" = "4",
                                              "5" = "5",
                                              "6" = "6",
                                              "7" = "7",
                                              "8" = "8",
                                              "9" = "9",
                                              "10" = "10",
                                              "11" = "11",
                                              "12" = "12",
                                              "13" = "13",
                                              "14" = "14",
                                              "15" = "15",
                                              "16" = "16",
                                              "17" = "17",
                                              "18" = "18",
                                              "19" = "19",
                                              "20" = "20",
                                              "21" = "21",
                                              "22" = "22"))
  expect_equal(sex_offender_values$DATE, c("Blanked" = "8888888"))
  expect_equal(sex_offender_values$Q1, c("Media" = "1",
                                         "Flyers" = "2",
                                         "Local official" = "3",
                                         "Friend, etc." = "4",
                                         "Other" = "5",
                                         "Not sure" = "6",
                                         "Multiple response" = "9",
                                         "Blank" = "99"))
  expect_equal(sex_offender_values$Q2A, c("Checked" = "1",
                                          "Blank" = "9"))
  expect_equal(sex_offender_values$Q3, c("Very clear" = "1",
                                         "Moderate clear" = "2",
                                         "Neutral" = "3",
                                         "Somewhat clear" = "4",
                                         "Very unclear" = "5",
                                         "Not sure" = "6",
                                         "Multiple response" = "9",
                                         "Blank" = "99"))
  expect_equal(sex_offender_values$Q6E, c("Checked" = "1",
                                          "Blank" = "9"))
  expect_equal(sex_offender_values$Q10, c("More anxious" = "1",
                                          "Very anxious" = "2",
                                          "Neutral" = "3",
                                          "Somewhat less" = "4",
                                          "Relieved" = "5",
                                          "No opinion" = "6",
                                          "Not sure" = "7",
                                          "Multiple response" = "9",
                                          "Blank" = "99"))
  expect_equal(sex_offender_values$INDEX, c("More concerned" = "1",
                                          "Neutral" = "2",
                                          "Less concerned" = "3",
                                          "Blank" = "9"))
  expect_equal(sex_offender_values$NEWQ9G, c("Inadequate" = "1",
                                             "Adequate +" = "2",
                                             "Blank" = "9"))

})

test_that("Sac - parsed value labels are accurate", {
  expect_equal(sac_values$TODDATYR, c("Unknown" = "9999"))
  expect_equal(sac_values$CONSTATE, c("Maricopa, AZ" = "1",
                                      "Sacramento, CA" = "2",
                                      "Unknown" = "9"))
  expect_equal(sac_values$Q2JAGE, c("18-30 yrs" = "1",
                                    "31-40 yrs" = "2",
                                    "41-50 yrs" = "3",
                                    "51-60 yrs" = "4",
                                    "61-70 yrs" = "5",
                                    "Over 70" = "6"))
  expect_equal(sac_values$Q3JETH, c("African American" = "1",
                              "Asian American" = "2",
                              "Caucasian" = "3",
                              "Hispanic/Latino" = "4",
                              "Other" = "5",
                              "Unknown" = "9"))
  expect_equal(sac_values$Q4JEDUC, c("H.S. or less / GED" = "1",
                              "College no degree" = "2",
                              "Associate degree" = "3",
                              "Bachelors" = "4",
                              "Graduate no degree" = "5",
                              "Graduate degree etc" = "6",
                              "Other" = "7"))
  expect_equal(length(sac_values$Q20TPEV3), 107)
  expect_equal(sac_values$KAGE, c("12 or younger at time of trial" = "1",
                                  "13 or older at time of trial" = "2",
                                  "Unknown" = "9"))
  expect_equal(sac_values$VERDICT, c("Not guilty" = "0",
                                     "Guilty" = "1",
                                     "Unknown" = "9"))
  expect_equal(sac_values$DURAT, c("Undoc code" = "-2",
                                   "Unknown" = "99"))
  expect_equal(sac_values$DURAT2, c("2 years or less" = "1",
                                    "3 years or more" = "2",
                                    "Unknown" = "9"))

})

test_that("Parole - parsed value labels are accurate", {
  expect_equal(parole_values$STATEID, c("Federal" = "0",
                                        "Alabama" = "1",
                                        "Alaska" = "2",
                                        "Arizona" = "4",
                                        "Arkansas" = "5",
                                        "California" = "6",
                                        "Colorado" = "8",
                                        "Connecticut" = "9",
                                        "Delaware" = "10",
                                        "District of Columbia" = "11",
                                        "Florida" = "12",
                                        "Georgia" = "13",
                                        "Hawaii" = "15",
                                        "Idaho" = "16",
                                        "Illinois" = "17",
                                        "Indiana" = "18",
                                        "Iowa" = "19",
                                        "Kansas" = "20",
                                        "Kentucky" = "21",
                                        "Louisiana" = "22",
                                        "Maine" = "23",
                                        "Maryland" = "24",
                                        "Massachusetts" = "25",
                                        "Michigan" = "26",
                                        "Minnesota" = "27",
                                        "Mississippi" = "28",
                                        "Missouri" = "29",
                                        "Montana" = "30",
                                        "Nebraska" = "31",
                                        "Nevada" = "32",
                                        "New Hampshire" = "33",
                                        "New Jersey" = "34",
                                        "New Mexico" = "35",
                                        "New York" = "36",
                                        "North Carolina" = "37",
                                        "North Dakota" = "38",
                                        "Ohio" = "39",
                                        "Oklahoma" = "40",
                                        "Oregon" = "41",
                                        "Pennsylvania" = "42",
                                        "Rhode Island" = "44",
                                        "South Carolina" = "45",
                                        "South Dakota" = "46",
                                        "Tennessee" = "47",
                                        "Texas" = "48",
                                        "Utah" = "49",
                                        "Vermont" = "50",
                                        "Virginia" = "51",
                                        "Washington" = "53",
                                        "West Virginia" = "54",
                                        "Wisconsin" = "55",
                                        "Wyoming" = "56"))
  expect_equal(parole_values$STATE, c("Alaska" = "AK",
                                      "Alabama" = "AL",
                                      "Arkansas" = "AR",
                                      "Arizona" = "AZ",
                                      "California" = "CA",
                                      "Colorado" = "CO",
                                      "Connecticut" = "CT",
                                      "District of Columbia" = "DC",
                                      "Delaware" = "DE",
                                      "Federal" = "FE",
                                      "Florida" = "FL",
                                      "Georgia" = "GA",
                                      "Hawaii" = "HI",
                                      "Iowa" = "IA",
                                      "Idaho" = "ID",
                                      "Illinois" = "IL",
                                      "Indiana" = "IN",
                                      "Kansas" = "KS",
                                      "Kentucky" = "KY",
                                      "Louisiana" = "LA",
                                      "Massachusetts" = "MA",
                                      "Maryland" = "MD",
                                      "Maine" = "ME",
                                      "Michigan" = "MI",
                                      "Minnesota" = "MN",
                                      "Missouri" = "MO",
                                      "Mississippi" = "MS",
                                      "Montana" = "MT",
                                      "North Carolina" = "NC",
                                      "North Dakota" = "ND",
                                      "Nebraska" = "NE",
                                      "New Hampshire" = "NH",
                                      "New Jersey" = "NJ",
                                      "New Mexico" = "NM",
                                      "Nevada" = "NV",
                                      "New York" = "NY",
                                      "Ohio" = "OH",
                                      "Oklahoma" = "OK",
                                      "Oregon" = "OR",
                                      "Pennsylvania" = "PA",
                                      "Rhode Island" = "RI",
                                      "South Carolina" = "SC",
                                      "South Dakota" = "SD",
                                      "Tennessee" = "TN",
                                      "Texas" = "TX",
                                      "Utah" = "UT",
                                      "Virginia" = "VA",
                                      "Vermont" = "VT",
                                      "Washington" = "WA",
                                      "Wisconsin" = "WI",
                                      "West Virginia" = "WV",
                                      "Wyoming" = "WY"))
  expect_equal(parole_values$TOTBEG, c("Not known/Dont know" = "-9",
                                       "Not applicable" = "-8"))
  expect_equal(parole_values$MALE, c("Not known/Dont know" = "-9",
                                     "Not applicable" = "-8"))
  expect_equal(parole_values$ISP, c("No program" = "N",
                                    "Yes" = "Y"))
  expect_equal(parole_values$ISPNUM, c("Not known/Dont know" = "-9",
                                       "Not applicable" = "-8"))
  expect_equal(parole_values$ISPIN, c("Not known/Dont know" = "DK",
                                      "No" = "N",
                                      "Not applicable" = "NA",
                                      "Yes" = "Y"))
  expect_equal(parole_values$EM, c("No program" = "N",
                                   "Yes" = "Y"))
  expect_equal(parole_values$ENDOFYEAR, c("Not known/Dont know" = "DK",
                                          "No" = "N",
                                          "Yes" = "Y"))

})


test_that("Prisoners - parsed value labels are accurate", {
  expect_equal(prisoners_values$STATEID, c("01. Alabama" = "1",
                                           "02. Alaska" = "2",
                                           "04. Arizona" = "4",
                                           "05. Arkansas" = "5",
                                           "06. California" = "6",
                                           "08. Colorado" = "8",
                                           "09. Connecticut" = "9",
                                           "10. Delaware" = "10",
                                           "11. District of Columbia" = "11",
                                           "12. Florida" = "12",
                                           "13. Georgia" = "13",
                                           "15. Hawaii" = "15",
                                           "16. Idaho" = "16",
                                           "17. Illinois" = "17",
                                           "18. Indiana" = "18",
                                           "19. Iowa" = "19",
                                           "20. Kansas" = "20",
                                           "21. Kentucky" = "21",
                                           "22. Louisiana" = "22",
                                           "23. Maine" = "23",
                                           "24. Maryland" = "24",
                                           "25. Massachusetts" = "25",
                                           "26. Michigan" = "26",
                                           "27. Minnesota" = "27",
                                           "28. Mississippi" = "28",
                                           "29. Missouri" = "29",
                                           "30. Montana" = "30",
                                           "31. Nebraska" = "31",
                                           "32. Nevada" = "32",
                                           "33. New Hampshire" = "33",
                                           "34. New Jersey" = "34",
                                           "35. New Mexico" = "35",
                                           "36. New York" = "36",
                                           "37. North Carolina" = "37",
                                           "38. North Dakota" = "38",
                                           "39. Ohio" = "39",
                                           "40. Oklahoma" = "40",
                                           "41. Oregon" = "41",
                                           "42. Pennsylvania" = "42",
                                           "44. Rhode Island" = "44",
                                           "45. South Carolina" = "45",
                                           "46. South Dakota" = "46",
                                           "47. Tennessee" = "47",
                                           "48. Texas" = "48",
                                           "49. Utah" = "49",
                                           "50. Vermont" = "50",
                                           "51. Virginia" = "51",
                                           "52. Jurisdiction shared between States" = "52",
                                           "53. Washington" = "53",
                                           "54. West Virginia" = "54",
                                           "55. Wisconsin" = "55",
                                           "56. Wyoming" = "56",
                                           "State prison total" = "60",
                                           "US prison total (state+federal)" = "70",
                                           "Federal BOP" = "99"))
  expect_equal(prisoners_values$REGION, c("Northeast" = "1",
                                          "Midwest" = "2",
                                          "South" = "3",
                                          "West" = "4",
                                          "U.S. total" = "5",
                                          "Federal Bureau of Prisons" = "6",
                                          "State total" = "7"))
  expect_equal(prisoners_values$CWPRIVM, c("Data are missing because the state did not respond to the item" = "-9",
                                           "Data are missing because the item was not applicable to the state" = "-8",
                                           "Item was asked, but only in the aggregate prison population, not by male or female" = "-2",
                                           "Item not asked in survey for this year" = "-1"))
  expect_equal(prisoners_values$PVOTHF, c("Data are missing because the state did not respond to the item" = "-9",
                                          "Data are missing because the item was not applicable to the state" = "-8",
                                          "Item was asked, but only in the aggregate prison population, not by male or female" = "-2",
                                          "Item not asked in survey for this year" = "-1"))
  expect_equal(prisoners_values$PVINCLF, c("Data are missing because the state did not respond to the item" = "-9",
                                           "Data are missing because the item was not applicable to the state" = "-8",
                                           "Item was asked, but only in the aggregate prison population, not by male or female" = "-2",
                                           "Item not asked in survey for this year" = "-1",
                                           "Yes" = "1",
                                           "No" = "2"))
  expect_equal(prisoners_values$HANDLEF, c("Data are missing because the state did not respond to the item" = "-9",
                                           "Data are missing because the item was not applicable to the state" = "-8",
                                           "Item was asked, but only in the aggregate prison population, not by male or female" = "-2",
                                           "Item not asked in survey for this year" = "-1"))

})


test_that("CA vital - parsed value labels are accurate", {
  expect_equal(ca_vital_values$VICSEX, c("Unknown" = "0",
                                         "Male" = "1",
                                         "Female" = "2"))
  expect_equal(ca_vital_values$CRIMEST, c("Actual" = "1",
                                          "Justifiable - private citizen" = "2",
                                          "Manslaughter" = "3",
                                          "Justifiable - peace officer" = "4"))
  expect_equal(length(ca_vital_values$PRECIP2), 46)
  expect_equal(ca_vital_values$SUS2RACE, c("Unknown" = "0",
                                           "White (not Hispanic)" = "1",
                                           "Hispanic" = "2",
                                           "Black" = "3",
                                           "American Indian" = "4",
                                           "Chinese" = "5",
                                           "Japanese" = "6",
                                           "Filipino" = "7",
                                           "Other" = "8",
                                           "Pacific Islander" = "9",
                                           "Other Asian" = "A",
                                           "Black" = "B",
                                           "Chinese" = "C",
                                           "Cambodian" = "D",
                                           "Filipino" = "F",
                                           "Guamanian" = "G",
                                           "Hispanic" = "H",
                                           "American Indian" = "I",
                                           "Japanese" = "J",
                                           "Korean" = "K",
                                           "Laotian" = "L",
                                           "Other" = "O",
                                           "Pacific Islander" = "P",
                                           "Samoan" = "S",
                                           "Hawaiian" = "U",
                                           "Vietnamese" = "V",
                                           "White" = "W",
                                           "Unknown" = "X",
                                           "Asian" = "Z"))
  expect_equal(ca_vital_values$EDUCATN, c("1 year of college" = "13",
                                          "2 years of college" = "14",
                                          "3 years of college" = "15",
                                          "4 years of college" = "16",
                                          "5+ years of college" = "17",
                                          "Unknown or not available" = "99"))
  expect_equal(ca_vital_values$FLAG, c("No estimate (incident day as reported)" = "0",
                                   "Estimate (incident day set to 01)" = "1"))
  expect_equal(ca_vital_values$HISPANIC, c("Not Spanish/Hispanic" = "1",
                                           "Mexican/Mexican-American/Chicano" = "2",
                                           "Puerto Rican" = "3",
                                           "Cuban" = "4",
                                           "Central/So. American" = "5",
                                           "(Born outside U.S.),other Spanish/Hispan" = "6",
                                           "Code not used" = "7",
                                           "(Born in the U.S.), other Spanish/Hispan" = "8",
                                           "Unknown or unreported" = "9"))
  expect_equal(ca_vital_values$MATCH, c("Death record did not match with homicide" = "0",
                                   "Death record matched with homicide recor" = "1"))
})


test_that("LEOKA 1980 - parsed value labels are accurate", {

  expect_equal(leoka1980_values$V7, c("ALL CITIE 250K+"  = "1",
                                      "CIT BET 100-249K" = "2",
                                      "CIT BET 50-99.9K" = "3",
                                      "CIT BET 25-49.9K" = "4",
                                      "CIT BET 10-24.9K" = "5",
                                      "CIT BET 2.5-9.9K" = "6",
                                      "CITIE UNDER 2.5K" = "7",
                                      "NON-SMSA COUNTIE" = "8",
                                      "SMSA COUNTIES"    = "9"))
  expect_equal(leoka1980_values$V8, c("POSSESS GUAM ETC"      = "0",
                                      "ALL CITIES 1M+"        = "11",
                                      "CIT BET 500-999K"      = "12",
                                      "CIT BET 250-499K"      = "13",
                                      "CIT BET 100-249K"      = "20",
                                      "CIT BET 50-99.9K"      = "30",
                                      "CIT BET 25-49.9K"      = "40",
                                      "CIT BET 10-24.9K"      = "50",
                                      "CIT BET 2.5-9.9K"      = "60",
                                      "CITIE UNDER 2.5K"      = "70",
                                      "NON-SMSA 100K+"        = "81",
                                      "NON-SMSA 25-99K"       = "82",
                                      "NON-SMSA 10-24K"       = "83",
                                      "NON-SMSA <10K"         = "84",
                                      "NON-SMSA STATE POLICE" = "85",
                                      "SMSA COUNT 10K+"       = "91",
                                      "SMSA 25-99.9K"         = "92",
                                      "SMSA 100K+"            = "93",
                                      "SMSA COUNT <10K"       = "94",
                                      "SMSA STATE POLICE"     = "95"))
  expect_equal(leoka1980_values$V11, c("GROUPS 8 AND 9" = "0"))
  expect_equal(leoka1980_values$V55, c("FOR ALL REPORTS" = "0",
                                       "CITY LIST ASSAUL" = "1",
                                       "CITY LIST ONLY" = "2"))
  expect_equal(leoka1980_values$V56, c("POL EMPLOY DA" = "0",
                                       "NOT UPDATED,NONE" = "1",
                                       "CONTAINS POL DA" = "2"))
  expect_equal(leoka1980_values$V72, c("NORMAL" = "0",
                                       "NO BREAKDOWNS. A" = "1"))
  expect_equal(leoka1980_values$V73, c("INFORMAT COMPLET" = "0",
                                       "ASSAULTS NOT REP" = "1",
                                       "ASSAULTS REPORTE" = "2"))
  expect_equal(leoka1980_values$V96,  c("INFORMAT COMPLET" = "0",
                                        "ASSAULTS NOT REP" = "1",
                                        "ASSAULTS REPORTE" = "2"))

})


test_that("Property stolen - parsed value labels are accurate", {

  expect_equal(property_stolen_values$V2, c("Alabama" = "1",
                                           "Arizona" = "2",
                                           "Arkansas" = "3",
                                           "California" = "4",
                                           "Colorado" = "5",
                                           "Connecticut" = "6",
                                           "Delaware" = "7",
                                           "District of Columbia" = "8",
                                           "Florida" = "9",
                                           "Georgia" = "10",
                                           "Idaho" = "11",
                                           "Illinois" = "12",
                                           "Indiana" = "13",
                                           "Iowa" = "14",
                                           "Kansas" = "15",
                                           "Kentucky" = "16",
                                           "Louisiana" = "17",
                                           "Maine" = "18",
                                           "Maryland" = "19",
                                           "Massachusetts" = "20",
                                           "Michigan" = "21",
                                           "Minnesota" = "22",
                                           "Mississippi" = "23",
                                           "Missouri" = "24",
                                           "Montana" = "25",
                                           "Nebraska" = "26",
                                           "Nevada" = "27",
                                           "New Hampshire" = "28",
                                           "New Jersey" = "29",
                                           "New Mexico" = "30",
                                           "New York" = "31",
                                           "North Carolina" = "32",
                                           "North Dakota" = "33",
                                           "Ohio" = "34",
                                           "Oklahoma" = "35",
                                           "Oregon" = "36",
                                           "Pennsylvania" = "37",
                                           "Rhode Island" = "38",
                                           "South Carolina" = "39",
                                           "South Dakota" = "40",
                                           "Tennessee" = "41",
                                           "Texas" = "42",
                                           "Utah" = "43",
                                           "Vermont" = "44",
                                           "Virginia" = "45",
                                           "Washington" = "46",
                                           "West Virginia" = "47",
                                           "Wisconsin" = "48",
                                           "Wyoming" = "49",
                                           "Alaska" = "50",
                                           "Hawaii" = "51",
                                           "Canal Zone" = "52",
                                           "Puerto Rico" = "53",
                                           "American Samoa" = "54",
                                           "Guam" = "55",
                                           "Virgin Islands" = "62"))
  expect_equal(property_stolen_values$V4, c("Possessions as Puerto Rico, Guam" = "0",
                                            "All cities 250,000 +" = "1",
                                            "Cit 1,000,000 +" = "1A",
                                            "Cit 500,000-999,999" = "1B",
                                            "Cit 250,000-499,999" = "1C",
                                            "Cit 100,000-249,999" = "2",
                                            "Cit 50,000-99,999" = "3",
                                            "Cit 25,000-49,999" = "4",
                                            "Cit 10,000-24,999" = "5",
                                            "Cit 2,500-9,999" = "6",
                                            "Cit < 2,500" = "7",
                                            "Non-MSA counties" = "8",
                                            "Non-MSA co. 100,000 +" = "8A",
                                            "Non-MSA co. 25,000-99,999" = "8B",
                                            "Non-MSA co. 10,000-24,999" = "8C",
                                            "Non-MSA co. < 10,000" = "8D",
                                            "Non-MSA state police" = "8E",
                                            "MSA counties" = "9",
                                            "MSA co. 100,000 +" = "9A",
                                            "MSA co. 25,000-99,999" = "9B",
                                            "MSA co. 10,000-24,999" = "9C",
                                            "MSA co. < 10,000" = "9D",
                                            "MSA state police" = "9E"))
  expect_equal(property_stolen_values$V5, c("Possessions" = "0",
                                            "New England" = "1",
                                            "Middle Atlantic" = "2",
                                            "East North Central" = "3",
                                            "West North Central" = "4",
                                            "South Atlantic" = "5",
                                            "East South Central" = "6",
                                            "West South Central" = "7",
                                            "Mountain" = "8",
                                            "Pacific" = "9"))
  expect_equal(property_stolen_values$V11, c("Not reported" = "0",
                                             "Regular"      = "1"))
  expect_equal(property_stolen_values$V104, c("Not reported" = "0",
                                              "Regular"      = "1"))
  expect_equal(property_stolen_values$V197, c("Not reported" = "0",
                                              "Regular"      = "1"))
  expect_equal(property_stolen_values$V290, c("Not reported" = "0",
                                              "Regular"      = "1"))
  expect_equal(property_stolen_values$V383, c("Not reported" = "0",
                                              "Regular"      = "1"))
  expect_equal(property_stolen_values$V476, c("Not reported" = "0",
                                              "Regular"      = "1"))
  expect_equal(property_stolen_values$V569, c("Not reported" = "0",
                                              "Regular"      = "1"))
  expect_equal(property_stolen_values$V662, c("Not reported" = "0",
                                              "Regular"      = "1"))
  expect_equal(property_stolen_values$V755, c("Not reported" = "0",
                                              "Regular"      = "1"))
  expect_equal(property_stolen_values$V848, c("Not reported" = "0",
                                              "Regular"      = "1"))
  expect_equal(property_stolen_values$V941, c("Not reported" = "0",
                                              "Regular"      = "1"))
  expect_equal(property_stolen_values$V1034, c("Not reported" = "0",
                                           "Regular"      = "1"))

})
