% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind.r, R/print.r
\name{print,asciiCbind-method}
\alias{print,asciiCbind-method}
\alias{show,asciiCbind-method}
\alias{print,asciiTable-method}
\alias{show,asciiTable-method}
\alias{print,asciiList-method}
\alias{show,asciiList-method}
\alias{print,asciiMixed-method}
\alias{show,asciiMixed-method}
\alias{print,Report-method}
\alias{show,Report-method}
\title{Print ascii object}
\usage{
\S4method{print}{asciiCbind}(
  x,
  type = getOption("asciiType"),
  file = NULL,
  append = FALSE,
  escape = FALSE,
  list.escape = c("\\\\_", "\\\\^"),
  ...
)

\S4method{show}{asciiCbind}(object)

\S4method{print}{asciiTable}(
  x,
  type = getOption("asciiType"),
  file = NULL,
  append = FALSE,
  escape = FALSE,
  list.escape = c("\\\\_", "\\\\^"),
  ...
)

\S4method{show}{asciiTable}(object)

\S4method{print}{asciiList}(
  x,
  type = getOption("asciiType"),
  file = NULL,
  append = FALSE,
  escape = FALSE,
  list.escape = c("\\\\_", "\\\\^"),
  ...
)

\S4method{show}{asciiList}(object)

\S4method{print}{asciiMixed}(
  x,
  type = getOption("asciiType"),
  file = NULL,
  append = FALSE,
  escape = FALSE,
  list.escape = c("\\\\_", "\\\\^"),
  ...
)

\S4method{show}{asciiMixed}(object)

\S4method{print}{Report}(x, help = FALSE, ...)

\S4method{show}{Report}(object)
}
\arguments{
\item{x}{An object of class \code{"asciiTable"}, \code{"asciiList"}, \code{"asciiMixed"}, \code{"asciiCbind"} or \code{"Report"}.}

\item{type}{Type of syntax produce.  Possible values for \code{type} are
\code{"asciidoc"}, \code{"t2t"}, \code{"rest"}, \code{"org"},
\code{"textile"} or \code{"pandoc"}.  Default value produce asciidoc syntax.}

\item{file}{A character string naming the file to print to. Default is
\code{NULL} (print to the console).}

\item{append}{If \code{TRUE}, code will be appended to \code{file} instead
of overwriting it. Default value is \code{FALSE}}

\item{escape}{If \code{TRUE}, characters in \code{list.escape} will be be
printed with a \code{\\}. Default value is \code{FALSE}}

\item{list.escape}{Character vector. Default value is \code{c("\\\\_",
"\\\\^")}}

\item{...}{Additional arguments.  (Currently ignored.)}

\item{object}{ascii or Report object}

\item{help}{logical print help? (objects of class \code{"Report"})}
}
\description{
Function displaying the asciidoc, txt2tags, reStructuredText, org or
textile code associated with the supplied object of class \code{ascii}.
}
\details{
The package provides the new global option \code{asciiType}. Default value
is \code{"asciidoc"} (see examples).
}
\examples{
data(esoph)
ascii(esoph[1:10,])
print(ascii(esoph[1:10,]), type = "t2t")
print(ascii(esoph[1:10,]), type = "rest")
print(ascii(esoph[1:10,]), type = "org")
print(ascii(esoph[1:10,]), type = "textile")
print(ascii(esoph[1:10,]), type = "pandoc")
options(asciiType = "rest")
ascii(esoph[1:10,])
options(asciiType = "asciidoc")
}
\seealso{
\code{\link{ascii}}
}
\author{
David Hajage \email{dhajage@gmail.com}
}
\keyword{print}
