% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RweaveAscii.r, R/weaverAscii.r
\name{RweaveReST}
\alias{RweaveReST}
\alias{RtangleReST}
\alias{RweaveReSTOptions}
\alias{RweaveReSTFinish}
\alias{RweaveReSTWritedoc}
\alias{RweaveReSTSetup}
\alias{RweaveReSTRuncode}
\alias{weaverReST}
\alias{weaverReSTSetup}
\title{A driver to parse sphinx noweb files with Sweave tool
This driver parses sphinx files containing R code and replace pieces of
code with their output.}
\usage{
RweaveReST()

RweaveReSTSetup(
  file,
  syntax,
  output = NULL,
  quiet = FALSE,
  debug = FALSE,
  extension = "rst",
  backend = "docutils, sphinx, ...",
  openSchunk = ".. code-block:: r\\n",
  closeSchunk = "\\n\\n",
  openSinput = "",
  closeSinput = "",
  openSoutput = "\\n",
  closeSoutput = "",
  indent = "  ",
  openInclude = ".. include::",
  closeInclude = ".rst",
  openFig = ".. image:: ",
  closeFig = "",
  ...
)

weaverReSTSetup(
  file,
  syntax,
  output = NULL,
  quiet = FALSE,
  debug = FALSE,
  extension = "rst",
  backend = "docutils, sphinx, ...",
  openSchunk = ".. code-block:: r\\n",
  closeSchunk = "\\n\\n",
  openSinput = "",
  closeSinput = "",
  openSoutput = "\\n",
  closeSoutput = "",
  indent = "  ",
  openInclude = ".. include::",
  closeInclude = ".rst",
  openFig = ".. image:: ",
  closeFig = "",
  use.cache = TRUE,
  ...
)

weaverReST()
}
\arguments{
\item{file}{file}

\item{syntax}{syntax}

\item{output}{output}

\item{quiet}{quite}

\item{debug}{debug}

\item{...}{...}

\item{use.cache}{use.cache}

\item{stylepath}{stylepath}
}
\value{
None value is returned. From a .Rnw noweb file, the corresponding
  .rst is produced (as eventuals files for graphs).
}
\description{
A driver to parse sphinx noweb files with Sweave tool
This driver parses sphinx files containing R code and replace pieces of
code with their output.

RweaveReSTSetup

weaverReSTSetup

weaverReST
}
\note{
In order to work properly, noweb codes have to be located at the
  beginning of a line (no indentation).

Compare with RweaveLatex driver, RweaveReST provides one new option :
  \code{format} to choose the format of figure that will be inserted in the
  final document.

In addition, \code{cache} option from \code{weaver}
  package is also available with \code{weaverReST} driver.

A wrapper for \code{Sweave} can be used, named \code{ReST}.
}
\examples{
  \dontrun{
ReST("file.Rnw")
  }

}
\seealso{
\code{\link[utils]{Sweave}}, \code{\link{ReST}}
}
\author{
David Hajage \email{dhajage@gmail.com}
}
\keyword{IO}
\keyword{file}
\keyword{internal}
