% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareTransactions.R
\name{prepareTransactions}
\alias{prepareTransactions}
\title{Prepare Data for Associative Classification}
\usage{
prepareTransactions(formula, data, disc.method = "mdlp", match = NULL)
}
\arguments{
\item{formula}{the formula.}

\item{data}{a data.frame with the data.}

\item{disc.method}{Discretization method used to discretize continuous
variables if data is a data.frame (default: \code{"mdlp"}). See
\code{\link{discretizeDF.supervised}} for more supervised discretization
methods.}

\item{match}{typically \code{NULL}. Only used internally if data is a
already a set of transactions.}
}
\value{
An object of class \code{\link[arules]{transactions}} from
\pkg{arules} with an attribute called \code{"disc_info"} that contains
information on the used discretization for each column.
}
\description{
Data in a data.frame are discretized using class-based
discretization and converted into transactions. For transaction data that was not created
from a data.frame, a negative class item is added to create data for a binary classifier.
}
\examples{

# Perform discretization and convert to transactions
data("iris")
iris_trans <- prepareTransactions(Species ~ ., iris)
inspect(head(iris_trans))

# A negative class item is added for regular transaction data (here "!canned beer")
# Note: backticks are needed in formulas with item labels that contain a space.
data("Groceries")
g2 <- prepareTransactions(`canned beer` ~ ., Groceries)
inspect(head(g2))

}
\seealso{
\code{\link[arules]{transactions}}, \code{\link{transactions2DF}}.
}
\author{
Michael Hahsler
}
