% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckdb.R
\name{to_duckdb}
\alias{to_duckdb}
\title{Create a (virtual) DuckDB table from an Arrow object}
\usage{
to_duckdb(
  .data,
  con = arrow_duck_connection(),
  table_name = unique_arrow_tablename(),
  auto_disconnect = TRUE
)
}
\arguments{
\item{.data}{the Arrow object (e.g. Dataset, Table) to use for the DuckDB table}

\item{con}{a DuckDB connection to use (default will create one and store it
in \code{options("arrow_duck_con")})}

\item{table_name}{a name to use in DuckDB for this object. The default is a
unique string \code{"arrow_"} followed by numbers.}

\item{auto_disconnect}{should the table be automatically cleaned up when the
resulting object is removed (and garbage collected)? Default: \code{FALSE}}
}
\value{
A \code{tbl} of the new table in DuckDB
}
\description{
This will do the necessary configuration to create a (virtual) table in DuckDB
that is backed by the Arrow object given. No data is copied or modified until
\code{collect()} or \code{compute()} are called or a query is run against the table.
}
\details{
The result is a dbplyr-compatible object that can be used in d(b)plyr pipelines.

If \code{auto_disconnect = TRUE}, the DuckDB table that is created will be configured
to be unregistered when the \code{tbl} object is garbage collected. This is helpful
if you don't want to have extra table objects in DuckDB after you've finished
using them. Currently, this cleanup can, however, sometimes lead to hangs if
tables are created and deleted in quick succession, hence the default value
of \code{FALSE}
}
\examples{
\dontshow{if (getFromNamespace("run_duckdb_examples", "arrow")()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)

ds <- InMemoryDataset$create(mtcars)

ds \%>\%
  filter(mpg < 30) \%>\%
  to_duckdb() \%>\%
  group_by(cyl) \%>\%
  summarize(mean_mpg = mean(mpg, na.rm = TRUE))
\dontshow{\}) # examplesIf}
}
