% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{Scanner}
\alias{Scanner}
\alias{ScannerBuilder}
\title{Scan the contents of a dataset}
\description{
A \code{Scanner} iterates over a \link{Dataset}'s fragments and returns data
according to given row filtering and column projection. Use a
\code{ScannerBuilder}, from a \code{Dataset}'s \verb{$NewScan()} method, to construct one.
}
\section{Methods}{

\code{ScannerBuilder} has the following methods:
\itemize{
\item \verb{$Project(cols)}: Indicate that the scan should only return columns given
by \code{cols}, a character vector of column names
\item \verb{$Filter(expr)}: Filter rows by an \link{Expression}.
\item \verb{$UseThreads(threads)}: logical: should the scan use multithreading?
The method's default input is \code{TRUE}, but you must call the method to enable
multithreading because the scanner default is \code{FALSE}.
\item \verb{$schema}: Active binding, returns the \link{Schema} of the Dataset
\item \verb{$Finish()}: Returns a \code{Scanner}
}

\code{Scanner} currently has a single method, \verb{$ToTable()}, which evaluates the
query and returns an Arrow \link{Table}.
}

