% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record-batch-writer.R
\docType{class}
\name{RecordBatchWriter}
\alias{RecordBatchWriter}
\alias{RecordBatchStreamWriter}
\alias{RecordBatchFileWriter}
\title{RecordBatchWriter classes}
\description{
\code{RecordBatchFileWriter} and \code{RecordBatchStreamWriter} are
interfaces for writing record batches to either the binary file or streaming
format.
}
\section{Usage}{
\preformatted{writer <- RecordBatchStreamWriter$create(sink, schema)

writer$write_batch(batch)
writer$write_table(table)
writer$close()
}
}

\section{Factory}{


The \code{RecordBatchFileWriter$create()} and \code{RecordBatchStreamWriter$create()}
factory methods instantiate the object and
take a single argument, named according to the class:
\itemize{
\item \code{sink} A character file name or an \code{OutputStream}.
\item \code{schema} A \link{Schema} for the data to be written.
}
}

\section{Methods}{

\itemize{
\item \code{$write(x)}: Write a \link{RecordBatch}, \link{Table}, or \code{data.frame}, dispatching
to the methods below appropriately
\item \code{$write_batch(batch)}: Write a \code{RecordBatch} to stream
\item \code{$write_table(table)}: Write a \code{Table} to stream
\item \code{$close()}: close stream
}
}

\keyword{datasets}
