% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunked-array.R
\docType{class}
\name{ChunkedArray}
\alias{ChunkedArray}
\alias{chunked_array}
\title{ChunkedArray class}
\usage{
chunked_array(..., type = NULL)
}
\arguments{
\item{\dots}{Vectors to coerce}

\item{type}{currently ignored}
}
\description{
A \code{ChunkedArray} is a data structure managing a list of
primitive Arrow \link[=Array]{Arrays} logically as one large array. Chunked arrays
may be grouped together in a \link{Table}.
}
\section{Factory}{

The \code{ChunkedArray$create()} factory method instantiates the object from
various Arrays or R vectors. \code{chunked_array()} is an alias for it.
}

\section{Methods}{

\itemize{
\item \code{$length()}
\item \code{$chunk(i)}
\item \code{$as_vector()}
\item \code{$Slice(offset, length = NULL)}
\item \code{$cast(target_type, safe = TRUE, options = cast_options(safe))}
\item \code{$null_count()}
\item \code{$chunks()}
\item \code{$num_chunks()}
\item \code{$type()}
\item \code{$View(type)}: Construct a zero-copy view of this chunked array with the given type.
\item \code{$Validate()} : Perform any validation checks to determine obvious inconsistencies
within the array's internal data. This can be an expensive check, potentially \code{O(length)}
}
}

\seealso{
\link{Array}
}
\keyword{datasets}
