% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argonNavbar.R
\name{argonNavbar}
\alias{argonNavbar}
\title{Create a Boostrap 4 argon navbar}
\usage{
argonNavbar(..., src = NULL, id)
}
\arguments{
\item{...}{Slot for \link{argonNavMenu}.}

\item{src}{Brand image path or url.}

\item{id}{Navbar toggle unique id.}
}
\description{
Build an argon navbar
}
\examples{
if(interactive()){
 library(argonR)
 argonNavbar(
  id = "main-navbar",
  src = "https://demos.creative-tim.com/argon-design-system/assets/img/brand/white.png",
  # left menu
  argonNavMenu(
    argonDropdown(
      name = "Components",
      size = "lg",
      argonDropdownItem(
        name = "Getting Started",
        description = "BlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBla",
        src = "test.html",
        icon = "spaceship",
        status = "primary"
      ),
      argonDropdownItem(
        name = "Foundation",
        description = "BlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBla",
        src = "",
        icon = "palette",
        status = "warning"
      ),
      argonDropdownItem(
        name = "Components",
        description = "BlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBlaBla",
        src = "",
        icon = "ui-04",
        status = "success"
      )
    )
  ),
  # right menu
  argonNavMenu(
    side = "right",
    argonNavItem(
      name = "facebook",
      src = "https://www.facebook.com",
      icon = "facebook-square",
      tooltip = "Like us on Facebook"
    ),
    argonNavItem(
      name = "instagram",
      src = "https://www.instagram.com",
      icon = "instagram",
      tooltip = "Follow us on Instagram"
    ),
    argonNavItem(
      name = "twitter",
      src = "https://www.twitter.com",
      icon = "twitter-square",
      tooltip = "Follow us on Twitter"
    ),
    argonNavItem(
      name = "github",
      src = "https://www.github.com",
      icon = "github",
      tooltip = "Star us on Github"
    )
  )
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
