% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\name{argoDefaultDestdir}
\alias{argoDefaultDestdir}
\alias{argoDefaultServer}
\alias{argoDefaultIndexAge}
\alias{argoDefaultProfileAge}
\alias{argoDefaultBathymetry}
\alias{hasArgoTestCache}
\title{Get Default Values}
\usage{
argoDefaultDestdir()

argoDefaultServer()

argoDefaultIndexAge()

argoDefaultProfileAge()

argoDefaultBathymetry()

hasArgoTestCache()
}
\value{
A value as described above, depending on the particular
function in question.
}
\description{
These are helper functions that permit customization of various aspects of
functions within the argoFloats package. The idea is that values can be set
using \code{\link[=options]{options()}} or by using system 'environment variables', freeing the
user from the necessity of altering the parameters provided to various
argoFloats functions.  See \dQuote{Details} for more on the individual
functions, noting that the entry for \code{argoDefaultServer()} is written with
the most detail, with other entries relying on the background
established there.
}
\details{
\itemize{
\item \code{argoDefaultServer()}
The \code{\link[=getIndex]{getIndex()}} and \code{\link[=getProfiles]{getProfiles()}} functions download data from a
remote machine with URL specified by an argument named \code{server}. A user may
prefer one server over another, perhaps due to speed of downloads to
a particular research laboratory.  However, that choice might not be best
for another user, or even the same user at another time.  Code reusability
would be enhanced if the user had a way to alter the value of the \code{server}
argument across all code, thereby eliminating the need to work in a text
editor to find all instances of the function call.  This is where
\code{argoDefaultServer()} is useful.  It lets the user specify a value for
\code{server} either in R, using a call like
\code{options(argoFloats.server="ifremer-https")}
within R code (perhaps in the user's \code{.Rprofile} file),
or by defining an environment variable named
\code{R_ARGOFLOATS_SERVER} at the operating-system level.  If
the \code{argoFloats.server} option has not been set in R,
and \code{R_ARGOFLOATS_SERVER} has not been set in the OS, then
\code{argoDefaultServer()} defaults to \code{c("ifremer-https","usgodae")}.
\item \code{argoDefaultDestdir()} returns the name of the local directory
into which to store indices and other argo data.
The option is named
\code{argoFloats.destdir},
the environment variable is named
\code{R_ARGOFLOATS_DESTDIR},
and the default is
`"~/data/argo".
\item \code{argoDefaultIndexAge()} returns the number of days beyond
which an index is regarded as stale (and thus in need of a new
download).
The option is named
\code{argoFloats.indexAge},
the environment variable is named
\code{R_ARGOFLOATS_INDEX_AGE},
and the default is
1.0, for 1 day.
\item \code{argoDefaultProfileAge()} returns the number of days beyond
which an individual profile netCDF file is regarded as stale (and thus in need of a new
download).
The option is named
\code{argoFloats.profileAge},
the environment variable is named
\code{R_ARGOFLOATS_PROFILE_AGE},
and the default is
365.0 days.  (Note that this is much higher than the value for
\code{argoDefaultIndexAge()}, on the assumption that users will prefer
recent indices, to get new data, but will prefer to update
profile-specific datasets infrequently.)
\item \code{argoDefaultBathymetry()} returns a value for the \code{bathymetry}
argument used by \code{\link[=plot,argoFloats-method]{plot,argoFloats-method()}}.
The option is named
\code{argoFloats.bathymetry},
the environment variable is named
\code{R_ARGOFLOATS_BATHYMETRY},
and the default is
\code{FALSE}.
\item \code{hasArgoTestCache()} is not a user-facing function. Rather, its purpose
is to speed the running of test suites during development, by preventing
multiple downloads of data already downloaded.
}
}
\examples{
argoDefaultServer()
argoDefaultDestdir()
argoDefaultIndexAge()
argoDefaultProfileAge()
argoDefaultBathymetry()

}
