% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confplot.R
\name{confplot}
\alias{confplot}
\alias{confplot.default}
\alias{confplot.formula}
\title{Plot Confidence Bands}
\usage{
confplot(x, ...)

\method{confplot}{default}(x, y1 = NULL, y2 = NULL, add = FALSE,
  xlab = NULL, ylab = NULL, border = NA, col = "lightgray", ...)

\method{confplot}{formula}(formula, data, subset, na.action = NULL, ...)
}
\arguments{
\item{x}{a numeric vector of x values. Alternatively, \code{x} can be a
matrix or data frame containing x values in the first column and lower
and upper y values in the next two columns.}

\item{\dots}{further arguments passed to \code{confplot.default},
\code{matplot}, and \code{polygon}.}

\item{y1}{a numeric vector of lower y values. Alternatively, \code{y1} can be
a matrix or data frame containing lower and upper y values in two
columns.}

\item{y2}{a numeric vector of upper y values, if not already supplied in
\code{x} or \code{y1}.}

\item{add}{whether confidence bands should be added to an existing plot.}

\item{xlab}{a label for x axis.}

\item{ylab}{a label for y axis.}

\item{border}{border color of polygon. The default \code{NA} is to omit
borders.}

\item{col}{fill color of polygon.}

\item{formula}{a \code{\link{formula}}, such as \code{cbind(y1,y2)~x},
specifying x and y values.}

\item{data}{a data frame (or list) from which the variables in formula should
be taken.}

\item{subset}{an optional vector specifying a subset of observations to be
used.}

\item{na.action}{a function which indicates what should happen when the data
contain \code{NA} values. The default is to ignore missing values in
the given variables.}
}
\value{
Data frame of coordinates that were used for plotting.
}
\description{
Plot confidence bands of lower and upper y values as a filled area, or add
polygon to an existing plot.
}
\examples{
model <- lm(log(dist)~log(speed), cars)
ci95 <- predict(model, data.frame(speed=4:25), interval="confidence")
ci50 <- predict(model, data.frame(speed=4:25), interval="confidence", level=0.5)
x <- log(4:25)
y1 <- ci95[,"lwr"]
y2 <- ci95[,"upr"]
mydata <- data.frame(x, y1, y2)

# Input format
confplot(x, y1, y2)               # vectors
confplot(x, cbind(y1,y2))         # y values in 2 columns
confplot(mydata)                  # data in 3 columns
confplot(cbind(y1,y2)~x, mydata)  # formula

# Overlay
plot(log(dist)~log(speed), cars, type="n")
confplot(x, ci95[,2:3], add=TRUE)
confplot(x, ci50[,2:3], add=TRUE, col="darkgray")
lines(x, ci95[,1])
points(log(dist)~log(speed), cars)

}
\seealso{
\code{\link{polygon}} is the underlying function used to draw polygons.

\code{\link{areaplot}} produces a stacked area plot.

\code{\link{areaplot-package}} gives an overview of the package.

The \pkg{gplots} and \pkg{plotrix} packages provide functions to plot error
bars.
}
