% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aread.R
\name{aread}
\alias{aread}
\title{Read Artifacts Given as md5hashes from the Repository}
\usage{
aread(md5hash)
}
\arguments{
\item{md5hash}{One of the following:

A character vector which elements  are consisting of at least three components separated with '/': Remote user name, Remote repository and name of the artifact (MD5 hash) or it's abbreviation.

MD5 hashes of artifacts in current local default directory or its abbreviations.}
}
\description{
\code{aread} reads the artifact from the \link{Repository}. It's a wrapper around 
\link{loadFromLocalRepo} and \link{loadFromRemoteRepo}.
}
\details{
Function \code{aread} reads artifacts (by \code{md5hashes}) from Remote Repository.
It uses \link{loadFromLocalRepo} and \link{loadFromRemoteRepo} functions
with different parameter's specification.
}
\note{
Before you start using this function, remember to set local or Remote repository
to default by using \code{setLocalRepo()} or \code{setRemoteRepo} functions.

Bug reports and feature requests can be sent to \href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}
\examples{
# read the object from local directory
setLocalRepo(system.file("graphGallery", package = "archivist"))
pl <- aread("f05f0ed0662fe01850ec1b928830ef32")
# plot it
pl
# read the object from Remote
pl <- aread("pbiecek/graphGallery/f05f0ed0662fe01850ec1b928830ef32")
# plot it
pl
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{cache}},
  \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}

