% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archive_write.R
\name{archive_write}
\alias{archive_write}
\title{Create a writable connection to a file in an archive.}
\usage{
archive_write(
  archive,
  file,
  mode = "w",
  format = NULL,
  filter = NULL,
  options = character()
)
}
\arguments{
\item{archive}{\code{character(1)} The archive filename or an \code{archive} object.}

\item{file}{\code{character(1) || integer(1)} The filename within the archive,
specified either by filename or by position.}

\item{mode}{\code{character(1)} A description of how to open the
connection (if it should be opened initially).  See section
‘Modes’ in \code{\link[base:connections]{base::connections()}} for possible values.}

\item{format}{\code{character(1)} default: \code{NULL} The archive format, one of \Sexpr[stage=render, results=rd]{archive:::choices_rd(names(archive:::archive_formats()))}.}

\item{filter}{\code{character(1)} default: \code{NULL} The archive filter, one of \Sexpr[stage=render, results=rd]{archive:::choices_rd(names(archive:::archive_filters()))}.}

\item{options}{\code{character()} default: \code{character(0)} Options to pass to the filter or format.
The list of available options are documented in
options can have one of the following forms:
\itemize{
\item \code{option=value}
The option/value pair will be provided to every module.
Modules that do not accept an option with this name will
ignore it.
\item \code{option}
The option will be provided to every module with a value
of "1".
\item \code{!option}
The option will be provided to every module with a NULL
value.
\item \code{module:option=value}, \code{module:option}, \code{module:!option}
As above, but the corresponding option and value will be
provided only to modules whose name matches module.
See \href{https://www.freebsd.org/cgi/man.cgi?query=archive_read_set_options&sektion=3&format=html}{read options} for available read options
See \href{https://www.freebsd.org/cgi/man.cgi?query=archive_write_set_options&sektion=3&format=html}{write options} for available write options
}}
}
\value{
An 'archive_write' connection to the file within the archive to be written.
}
\description{
Create a writable connection to a file in an archive.
}
\details{
If \code{format} and \code{filter} are \code{NULL}, they will be set automatically based on
the file extension given in \code{file} when writing and automatically detected
using
\href{https://github.com/libarchive/libarchive/wiki/FormatDetection}{Robust automatic format detection}
when reading.

For traditional zip archives \code{\link[=archive_write]{archive_write()}} creates a connection which
writes the data to the specified file directly. For other archive formats
the file size must be known when the archive is created, so the data is
first written to a scratch file on disk and then added to the archive. This
scratch file is automatically removed when writing is complete.
}
\examples{
# Archive format and filters can be set automatically from the file extensions.
f1 <- tempfile(fileext = ".tar.gz")

write.csv(mtcars, archive_write(f1, "mtcars.csv"))
archive(f1)
unlink(f1)

# They can also be specified explicitly
f2 <- tempfile()
write.csv(mtcars, archive_write(f2, "mtcars.csv", format = "tar", filter = "bzip2"))
archive(f2)
unlink(f2)

# You can also pass additional options to control things like compression level
f3 <- tempfile(fileext = ".tar.gz")
write.csv(mtcars, archive_write(f3, "mtcars.csv", options = "compression-level=2"))
archive(f3)
unlink(f3)
}
