% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-auth.R
\name{auth_code}
\alias{auth_code}
\alias{auth_client}
\alias{auth_binding}
\alias{auth_user}
\alias{refresh_token}
\alias{validate_or_refresh_token}
\title{Authorization}
\usage{
auth_code(client = Sys.getenv("ARCGIS_CLIENT"), host = arc_host())

auth_client(
  client = Sys.getenv("ARCGIS_CLIENT"),
  secret = Sys.getenv("ARCGIS_SECRET"),
  host = arc_host(),
  expiration = 120
)

auth_binding()

auth_user(
  username = Sys.getenv("ARCGIS_USER"),
  password = Sys.getenv("ARCGIS_PASSWORD"),
  host = arc_host(),
  expiration = 60
)

refresh_token(token, client = Sys.getenv("ARCGIS_CLIENT"), host = arc_host())

validate_or_refresh_token(
  token,
  client = Sys.getenv("ARCGIS_CLIENT"),
  host = arc_host(),
  refresh_threshold = 0,
  call = rlang::caller_env()
)
}
\arguments{
\item{client}{an OAuth 2.0 developer application client ID. By default uses the
environment variable \code{ARCGIS_CLIENT}.}

\item{host}{default \code{"https://www.arcgis.com"}}

\item{secret}{an OAuth 2.0 developer application secret. By default uses the environment
variable \code{ARCGIS_SECRET}.}

\item{expiration}{the duration of the token in minutes.}

\item{username}{default \code{Sys.getenv("ARCGIS_USER")}.
Your username to login. \strong{Do not} hard code this value.}

\item{password}{default \code{Sys.getenv("ARCGIS_PASSWORD")}.
Your password to login. \strong{Do not} hard code this value.}

\item{token}{an \code{httr2_token} as created by \code{auth_code()} or similar}

\item{refresh_threshold}{default \code{0}. If token expiry is within this
threshold (in seconds) the token will be refreshed only if a
\code{refresh_token} is available. Token refreshing is only possible with
\code{auth_code()} flow.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
an \code{httr2_token}
}
\description{
Authorize your R session to connect to an ArcGIS Portal. See details.
}
\details{
ArcGIS Online and Enterprise Portals utilize OAuth2 authorization via their REST APIs.
\itemize{
\item \code{auth_code()} is the recommend OAuth2 workflow for interactive sessions
\item \code{auth_client()} is the recommended OAuth2 workflow for non-interactive sessions
\item \code{auth_user()} uses legacy username and password authorization using the \code{generateToken} endpoint. It is only recommended for legacy systems that do not implement OAuth2.
\item \code{auth_binding()} fetches a token from the active portal set by \code{arcgisbinding}. Uses \code{arcgisbinding::arc.check_portal()} to extract the authorization token. Recommended if using arcgisbinding.
}
}
\examples{

\dontrun{
  auth_code()
  auth_client()
  auth_user()
  auth_binding()
}
}
