% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_iemre_apsim_met.R
\name{get_iem_apsim_met}
\alias{get_iem_apsim_met}
\title{Get weather data from Iowa Environmental Ag Weather Stations}
\usage{
get_iem_apsim_met(lonlat, dates, wrt.dir = ".", state, station, filename)
}
\arguments{
\item{lonlat}{Longitude and latitude vector (optional)}

\item{dates}{date ranges}

\item{wrt.dir}{write directory}

\item{state}{state which you choose climate data from}

\item{station}{station which you choose cliamte data from}

\item{filename}{file name for writing out to disk}
}
\value{
returns an object of class \sQuote{met} and writes a file to disk when filename is supplied.
}
\description{
Retrieves weather data from Iowa Environmental Mesonet (AgWeather) into an APSIM met file
}
\details{
The original data can be obtained from: https://mesonet.agron.iastate.edu/request/coop/fe.phtml

If the filename is not provided it will not write the file to disk, 
but it will return an object of class \sQuote{met}. This is useful in case manipulation
is required before writing to disk. For this function either provide the longitude 
and latitude or the state and station, but not both. In fact, \sQuote{state} and
\sQuote{station} will be ignored if \sQuote{lonlat} is supplied.
}
\examples{
\dontrun{
## This will not write a file to disk
iem.met <- get_iem_apsim_met(state = "IA", 
                             station = "IA0200", 
                             dates = c("2012-01-01","2012-12-31"))

summary(iem.met)

## Alternatively, coordinates can be used
## This should be equivalent to the previous request
iem.met2 <- get_iem_apsim_met(lonlat = c(-93.77, 42.02), 
                              dates = c("2012-01-01","2012-12-31"))

summary(iem.met2)
}

}
