% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_apsim.R
\name{compare_apsim}
\alias{compare_apsim}
\alias{print.out_mrg}
\alias{plot.out_mrg}
\title{Compare two or more apsim output objects}
\usage{
compare_apsim(..., variable, index = "Date", by, labels, verbose = FALSE)

\method{print}{out_mrg}(x, ..., digits = 2)

\method{plot}{out_mrg}(
  x,
  ...,
  plot.type = c("vs", "diff", "ts", "density"),
  pairs = c(1, 2),
  cumulative = FALSE,
  variable,
  id,
  span = 0.75
)
}
\arguments{
\item{...}{data frames with APSIM output or observed data.}

\item{variable}{variable to plot}

\item{index}{index for merging objects. Default is \sQuote{Date}}

\item{by}{factor for splitting the comparison, such as a treatment effect.}

\item{labels}{labels for plotting and identification of objects.}

\item{verbose}{whether to print indexes to console (default is FALSE).}

\item{x}{object of class \sQuote{out_mrg}}

\item{digits}{digits to print (default is 2)}

\item{plot.type}{either \sQuote{vs}, \sQuote{diff}, \sQuote{ts} - for time series or \sQuote{density}}

\item{pairs}{pair of objects to compare, defaults to 1 and 2 but others are possible}

\item{cumulative}{whether to plot cummulative values (default FALSE)}

\item{id}{identification (not implemented yet)}

\item{span}{argument passed to \sQuote{geom_smooth}}
}
\value{
object of class \sQuote{out_mrg}, which can be used for further plotting

it prints the index.table data.frame

it produces a plot
}
\description{
Function which allows for a simple comparison between APSIM output objects

print method for \sQuote{out_mrg}

plotting function for compare_apsim, it requires ggplot2
}
\note{
\sQuote{Con Corr} is the concordance correlation coefficient (https://en.wikipedia.org/wiki/Concordance_correlation_coefficient);
\sQuote{ME} is the model efficiency (https://en.wikipedia.org/wiki/Nash%E2%80%93Sutcliffe_model_efficiency_coefficient)
}
\examples{
\donttest{
## Directory with files
extd.dir <- system.file("extdata", package = "apsimx")
## Comparing observed and simulated for Wheat
data(obsWheat)
sim.opt <- read.csv(file.path(extd.dir, "wheat-sim-opt.csv"))
sim.opt$Date <- as.Date(sim.opt$Date)

cap <- compare_apsim(obsWheat, sim.opt, labels = c("obs", "sim"))

plot(cap)
plot(cap, plot.type = "diff")
plot(cap, plot.type = "ts")

plot(cap, variable = "AboveGround")
plot(cap, variable = "AboveGround", plot.type = "diff")
plot(cap, variable = "AboveGround", plot.type = "ts")
}

}
