% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_daymet_apsim_met.R
\name{get_daymet2_apsim_met}
\alias{get_daymet2_apsim_met}
\title{Get DAYMET data for an APSIM met file}
\source{
The data is retrieved using the \CRANpkg{daymetr} package. For the original
source see: https://daymet.ornl.gov/
}
\usage{
get_daymet2_apsim_met(lonlat, years, wrt.dir = ".", filename, silent = FALSE)
}
\arguments{
\item{lonlat}{Longitude and latitude vector}

\item{years}{a numeric vector of years to extract}

\item{wrt.dir}{write directory (default is the current directory)}

\item{filename}{file name for writing out to disk}

\item{silent}{argument passed to \code{\link[daymetr]{download_daymet}}}
}
\description{
Uses \code{\link[daymetr]{download_daymet}} from the \CRANpkg{daymetr} package to download data to create an APSIM met file.
}
\details{
This function requires the \CRANpkg{daymetr} package. This function should replace 
the \code{\link{get_daymet_apsim_met}} function.

If the filename is not provided it will not write the file to disk, 
but it will return an object of class \sQuote{met}. This is useful in case manipulation
is required before writing to disk. The variable \sQuote{srad} as downloaded from
daymet is average solar radiation, so it is converted to total. 
Daily total radiation (MJ/m2/day) can be calculated as 
follows: ((srad (W/m2) * dayl (s/day)) / 1,000,000) \cr
Vapor Pressure Deficit (vp) should be in hecto Pascals
}
\examples{
\dontrun{
require(daymetr)
## I write to a temp directory but replace as needed
dmet12 <- get_daymet2_apsim_met(lonlat = c(-93,42), years = 2012)
summary(dmet12)
## Check for reasonable ranges 
check_apsim_met(dmet12)
}

}
