% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsim_classic.R
\name{apsim_example}
\alias{apsim_example}
\title{Access Example APSIM Simulations}
\usage{
apsim_example(example = "Millet", silent = FALSE, tmp.dir = NULL)
}
\arguments{
\item{example}{run an example from built-in APSIM. Options are all of the ones included with the APSIM distribution, except \sQuote{Graph}.}

\item{silent}{whether to print standard output from the APSIM execution}

\item{tmp.dir}{temporary directory where to write files}
}
\description{
simple function to run some of the built-in APSIM examples
}
\details{
This function creates a temporary copy of the example file distributed with APSIM to avoid writing a .out file 
         to the directory where the \sQuote{Examples} are located. It is not a good practice and there is no guarantee that 
         the user has read/write permissions in that directory.
}
\note{
This function creates a new column \sQuote{Date} which is in the R \sQuote{Date} format which is convenient for graphics.
}
\examples{
\dontrun{
## Only run these if you have APSIM 'Classic' installed (Windows only)
millet <- apsim_example("Millet")
potato <- apsim_example("Potato")
sugar <- apsim_example("Sugar")
## The 'Date' column is created by this function, based on apsim output.
require(ggplot2)
ggplot(data = millet , aes(x = Date, y = millet_biomass)) + 
  geom_line()
}

}
