% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport_plan.R
\name{as.matrix.transport.plan}
\alias{as.matrix.transport.plan}
\title{Transform transportation plan to transportation matrix}
\usage{
\method{as.matrix}{transport.plan}(x, ...)
}
\arguments{
\item{x}{An object of class `transport.plan`. See output of (transport_plan)[transport_plan()]}

\item{...}{Unused arguments}
}
\value{
A matrix specifying the minimal joint distribution between samples. Margins will be equal to the marginal distributions of the samples
}
\description{
Transform transportation plan to transportation matrix
}
\examples{
set.seed(203987)
n <- 5
d <- 2
x <- matrix(rnorm(d*n), nrow=d, ncol=n)
y <- matrix(rnorm(d*n), nrow=d, ncol=n)
#get hilbert sort orders for x in backwards way
trans_plan <- transport_plan(X=x, Y=x, ground_p = 2, p = 2, 
                         observation.orientation =  "colwise", 
                         method = "hilbert")
trans_matrix <- as.matrix(trans_plan)
print(trans_matrix)
}
